/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import java.util.regex.Pattern;

public class URLReplacer {
    private static final Pattern URL_REGEX = Pattern.compile("((?:ht|f)tps?://|(?<![\\p{L}0-9_.])www\\.)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[^\\s\u3000]*");
    private final String replacedText;

    public URLReplacer(String replacedText) {
        this.replacedText = replacedText;
    }

    public String replace(String text) {
        if (text.contains("http") | text.contains("ftp")) {
            return URL_REGEX.matcher(text).replaceAll(this.replacedText);
        }
        return text;
    }
}

