/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.ImmortalityTimer;
import dev.felnull.itts.core.discord.ConnectControl;
import dev.felnull.itts.core.discord.DCEventListener;
import dev.felnull.itts.core.discord.command.AdminCommand;
import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.discord.command.ConfigCommand;
import dev.felnull.itts.core.discord.command.DenyCommand;
import dev.felnull.itts.core.discord.command.DictCommand;
import dev.felnull.itts.core.discord.command.InfoCommand;
import dev.felnull.itts.core.discord.command.JoinCommand;
import dev.felnull.itts.core.discord.command.LeaveCommand;
import dev.felnull.itts.core.discord.command.ReconnectCommand;
import dev.felnull.itts.core.discord.command.SkipCommand;
import dev.felnull.itts.core.discord.command.VnickCommand;
import dev.felnull.itts.core.discord.command.VoiceCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.managers.Presence;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class Bot
implements ITTSRuntimeUse {
    protected final List<BaseCommand> baseCommands = new ArrayList<BaseCommand>();
    private final ConnectControl connectControl = new ConnectControl();
    private JDA jda;

    public void start() {
        this.registeringCommands();
        this.jda = JDABuilder.createDefault((String)this.getConfigManager().getConfig().getBotToken()).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).addEventListeners(new Object[]{new DCEventListener(this), this.connectControl.getAdaptor()}).build();
        this.updateCommands(this.jda);
        this.jda.getPresence().setStatus(OnlineStatus.ONLINE);
        this.updateActivity(this.jda.getPresence());
        this.getImmortalityTimer().schedule(new ImmortalityTimer.ImmortalityTimerTask(){

            @Override
            public void run() {
                Bot.this.updateActivityAsync();
            }
        }, 0L, 10000L);
    }

    private void registeringCommands() {
        this.registerCommand(new JoinCommand());
        this.registerCommand(new LeaveCommand());
        this.registerCommand(new ReconnectCommand());
        this.registerCommand(new VoiceCommand());
        this.registerCommand(new VnickCommand());
        this.registerCommand(new InfoCommand());
        this.registerCommand(new ConfigCommand());
        this.registerCommand(new DenyCommand());
        this.registerCommand(new AdminCommand());
        this.registerCommand(new DictCommand());
        this.registerCommand(new SkipCommand());
    }

    private void registerCommand(BaseCommand command) {
        this.baseCommands.add(command);
    }

    private void updateCommands(JDA jda) {
        jda.updateCommands().addCommands(this.baseCommands.stream().map(BaseCommand::createSlashCommand).toList()).queue();
    }

    public void updateActivityAsync() {
        CompletableFuture.runAsync(() -> this.updateActivity(this.jda.getPresence()), this.getAsyncExecutor());
    }

    public void updateActivity(Presence presence) {
        String vstr = this.getITTSRuntime().getVersionText();
        int ct = this.getTTSManager().getTTSCount();
        if (ct > 0) {
            presence.setActivity(Activity.listening((String)(vstr + " - " + ct + "\u500b\u306e\u30b5\u30fc\u30d0\u30fc\u3067\u8aad\u307f\u4e0a\u3052")));
        } else {
            presence.setActivity(Activity.playing((String)(vstr + " - \u5f85\u6a5f")));
        }
    }

    public JDA getJDA() {
        return this.jda;
    }

    public long getBotId() {
        return this.jda.getSelfUser().getIdLong();
    }

    public ConnectControl getConnectControl() {
        return this.connectControl;
    }
}

