/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord;

import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.ImmortalityTimer;
import dev.felnull.itts.core.discord.AutoDisconnectMode;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.tts.TTSChannelPair;
import dev.felnull.itts.core.tts.TTSInstance;
import dev.felnull.itts.core.tts.TTSManager;
import dev.felnull.itts.core.tts.saidtext.StartupSaidText;
import dev.felnull.itts.core.voice.VoiceManager;
import dev.felnull.itts.core.voice.VoiceType;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.events.guild.voice.GuildVoiceUpdateEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.managers.AudioManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConnectControl {
    private static final Duration DISCONNECT_WAIT_DURATION = Duration.of(10L, ChronoUnit.SECONDS);
    private final DiscordEventAdaptor adaptor = new DiscordEventAdaptor();
    private final Map<Long, AutoDisconnecter> autoDisconnecters = new Long2ObjectOpenHashMap();

    protected DiscordEventAdaptor getAdaptor() {
        return this.adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAutoDisconnecter(long guildId) {
        AutoDisconnecter disconnecter = null;
        Map<Long, AutoDisconnecter> map = this.autoDisconnecters;
        synchronized (map) {
            if (!this.autoDisconnecters.containsKey(guildId)) {
                disconnecter = new AutoDisconnecter(guildId);
                this.autoDisconnecters.put(guildId, disconnecter);
            }
        }
        if (disconnecter != null) {
            disconnecter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAutoDisconnecter(long guildId) {
        AutoDisconnecter disconnecter;
        Map<Long, AutoDisconnecter> map = this.autoDisconnecters;
        synchronized (map) {
            disconnecter = this.autoDisconnecters.remove(guildId);
        }
        if (disconnecter != null) {
            disconnecter.cancel();
        }
    }

    private void startUpReconnect(long guildId, BotStateData data) {
        TTSChannelPair reconnectChannel;
        VoiceChannel audioChannel;
        JDA jda = ITTSRuntime.getInstance().getBot().getJDA();
        Guild guild = jda.getGuildById(guildId);
        if (guild == null) {
            return;
        }
        long audioCh = -1L;
        long textCh = -1L;
        DataRepository repo = SaveDataManager.getInstance().getRepository();
        AutoDisconnectMode autoDisMode = repo.getServerData(guildId).getAutoDisconnectMode();
        TTSChannelPair connectedChannelPair = data.getConnectedChannelPair();
        if (connectedChannelPair != null) {
            boolean conFlg = false;
            if (autoDisMode.isOn()) {
                audioChannel = guild.getVoiceChannelById(connectedChannelPair.speakAudioChannel());
                if (audioChannel != null) {
                    if (!ConnectControl.isNoUser((AudioChannel)audioChannel)) {
                        conFlg = true;
                    } else if (autoDisMode.isReconnect()) {
                        data.setReconnectChannelPair(connectedChannelPair);
                    }
                }
            } else {
                conFlg = true;
            }
            if (conFlg) {
                audioCh = connectedChannelPair.speakAudioChannel();
                textCh = connectedChannelPair.readTextChannel();
            }
        } else if (repo.getServerData(guildId).getAutoDisconnectMode().isReconnect() && (reconnectChannel = repo.getBotStateData(guildId, ITTSRuntime.getInstance().getBot().getBotId()).getReconnectChannelPair()) != null && (audioChannel = guild.getVoiceChannelById(reconnectChannel.speakAudioChannel())) != null && !ConnectControl.isNoUser((AudioChannel)audioChannel) && reconnectChannel.speakAudioChannel() != -1L && reconnectChannel.readTextChannel() != -1L) {
            audioCh = reconnectChannel.speakAudioChannel();
            textCh = reconnectChannel.readTextChannel();
        }
        if (audioCh < 0L || textCh < 0L) {
            return;
        }
        TTSManager ttsManager = ITTSRuntime.getInstance().getTTSManager();
        Logger logger = ITTSRuntime.getInstance().getLogger();
        VoiceManager voiceManager = ITTSRuntime.getInstance().getVoiceManager();
        long selfId = jda.getSelfUser().getIdLong();
        try {
            AudioChannel audioChannel2 = (AudioChannel)guild.getChannelById(AudioChannel.class, audioCh);
            if (audioChannel2 == null) {
                data.setConnectedChannelPair(null);
                logger.info("Failed to reconnect (Audio channel does not exist): {}", (Object)guild.getName());
                return;
            }
            TextChannel chatChannel = guild.getTextChannelById(textCh);
            if (chatChannel == null) {
                data.setConnectedChannelPair(null);
                logger.info("Failed to reconnect (Message channel does not exist): {}", (Object)guild.getName());
                return;
            }
            ttsManager.setReadAroundChannel(guild, (MessageChannel)chatChannel);
            try {
                guild.getAudioManager().openAudioConnection(audioChannel2);
            }
            catch (InsufficientPermissionException ex) {
                data.setConnectedChannelPair(null);
                logger.info("Failed to reconnect (No permission): {}", (Object)guild.getName());
                return;
            }
            ttsManager.connect(guild, audioChannel2);
            TTSInstance ti = ttsManager.getTTSInstance(guildId);
            VoiceType vt = voiceManager.getVoiceType(guildId, selfId);
            if (ti != null && vt != null && ttsManager.canSpeak(guild)) {
                ti.sayText(new StartupSaidText(vt.createVoice(guildId, selfId)));
            }
            logger.info("Reconnected: {}", (Object)guild.getName());
        }
        catch (Exception ex) {
            logger.error("Failed to reconnect: {}", (Object)guild.getName(), (Object)ex);
        }
    }

    private void joinReconnect(TTSChannelPair ttsChannel, Guild guild, AudioChannelUnion channelUnion, AudioManager audioManager) {
        TTSManager ttsManager = ITTSRuntime.getInstance().getTTSManager();
        TextChannel channel = guild.getTextChannelById(ttsChannel.readTextChannel());
        if (channel == null) {
            return;
        }
        ttsManager.setReadAroundChannel(guild, (MessageChannel)channel);
        try {
            audioManager.openAudioConnection((AudioChannel)channelUnion);
        }
        catch (InsufficientPermissionException insufficientPermissionException) {
            // empty catch block
        }
    }

    public static boolean isNoUser(AudioChannel channel) {
        return channel.getMembers().stream().allMatch(n -> n.getUser().isBot() || n.getUser().isSystem());
    }

    public void updateAutoDisconnectMode(long serverId) {
        Guild guild = ITTSRuntime.getInstance().getBot().getJDA().getGuildById(serverId);
        if (guild == null) {
            return;
        }
        AudioManager audioManager = guild.getAudioManager();
        AudioChannelUnion connectChannel = audioManager.getConnectedChannel();
        if (connectChannel == null) {
            return;
        }
        DataRepository repo = SaveDataManager.getInstance().getRepository();
        AutoDisconnectMode autoDisMode = repo.getServerData(serverId).getAutoDisconnectMode();
        if (autoDisMode.isOn()) {
            if (ConnectControl.isNoUser((AudioChannel)connectChannel)) {
                this.startAutoDisconnecter(serverId);
            }
        } else {
            this.stopAutoDisconnecter(serverId);
        }
    }

    protected final class DiscordEventAdaptor
    extends ListenerAdapter {
        protected DiscordEventAdaptor() {
        }

        public void onGuildVoiceUpdate(@NotNull GuildVoiceUpdateEvent event) {
            TTSChannelPair reconnectChannel;
            AudioChannelUnion joinCh = event.getChannelJoined();
            AudioChannelUnion leftCh = event.getChannelLeft();
            if (joinCh == null && leftCh == null) {
                return;
            }
            Member member = event.getMember();
            JDA jda = event.getJDA();
            Guild guild = Objects.requireNonNull(event.getGuild());
            long guildId = guild.getIdLong();
            DataRepository repo = SaveDataManager.getInstance().getRepository();
            AutoDisconnectMode autoDisMode = repo.getServerData(guildId).getAutoDisconnectMode();
            if (member.getUser().getIdLong() == jda.getSelfUser().getIdLong()) {
                ConnectControl.this.stopAutoDisconnecter(guildId);
                if (joinCh != null) {
                    repo.getBotStateData(guildId, ITTSRuntime.getInstance().getBot().getBotId()).setReconnectChannelPair(null);
                    if (autoDisMode.isOn() && ConnectControl.isNoUser((AudioChannel)joinCh)) {
                        ConnectControl.this.startAutoDisconnecter(guildId);
                    }
                }
                return;
            }
            if (member.getUser().isBot() || member.getUser().isSystem()) {
                return;
            }
            AudioManager audioManager = guild.getAudioManager();
            AudioChannelUnion selfCh = audioManager.getConnectedChannel();
            if (autoDisMode.isReconnect() && joinCh != null && selfCh == null && (reconnectChannel = repo.getBotStateData(guildId, ITTSRuntime.getInstance().getBot().getBotId()).getReconnectChannelPair()) != null && reconnectChannel.readTextChannel() != -1L && reconnectChannel.speakAudioChannel() != -1L && reconnectChannel.speakAudioChannel() == joinCh.getIdLong()) {
                ConnectControl.this.joinReconnect(reconnectChannel, guild, joinCh, audioManager);
            }
            if (autoDisMode.isOn() && selfCh != null) {
                long selfChId = selfCh.getIdLong();
                if (leftCh != null && leftCh.getIdLong() == selfChId && ConnectControl.isNoUser((AudioChannel)leftCh)) {
                    ConnectControl.this.startAutoDisconnecter(guildId);
                }
                if (joinCh != null && joinCh.getIdLong() == selfChId) {
                    ConnectControl.this.stopAutoDisconnecter(guildId);
                }
            }
        }

        public void onReady(@NotNull ReadyEvent event) {
            CompletableFuture.runAsync(() -> {
                long botId = ITTSRuntime.getInstance().getBot().getBotId();
                Map<Long, BotStateData> allData = SaveDataManager.getInstance().getRepository().getAllBotStateData(botId);
                allData.forEach((guildId, data) -> {
                    try {
                        ConnectControl.this.startUpReconnect((long)guildId, (BotStateData)data);
                    }
                    catch (Exception ex) {
                        ITTSRuntime.getInstance().getLogger().error("Reconnection process failed: {}", (Object)("GuildID:" + guildId), (Object)ex);
                    }
                });
            }, ITTSRuntime.getInstance().getAsyncWorkerExecutor());
        }
    }

    private class AutoDisconnecter {
        private final long guildId;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);
        private final AtomicReference<ImmortalityTimer.ImmortalityTimerTask> timerTask = new AtomicReference();

        private AutoDisconnecter(long guildId) {
            this.guildId = guildId;
        }

        private void start() {
            if (this.destroyed.get()) {
                return;
            }
            if (!this.timerTask.compareAndSet(null, this.createTimerTask())) {
                return;
            }
            ImmortalityTimer timer = ITTSRuntime.getInstance().getImmortalityTimer();
            timer.schedule(this.timerTask.get(), DISCONNECT_WAIT_DURATION.toMillis());
        }

        private ImmortalityTimer.ImmortalityTimerTask createTimerTask() {
            return new ImmortalityTimer.ImmortalityTimerTask(){

                @Override
                public void run() {
                    AutoDisconnecter.this.execute();
                }
            };
        }

        private void cancel() {
            if (!this.destroyed.compareAndSet(false, true)) {
                return;
            }
            ImmortalityTimer.ImmortalityTimerTask task = this.timerTask.get();
            if (task != null) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            JDA jda;
            Guild guild;
            TTSManager ttsManager;
            TTSInstance ttsInstance;
            if (!this.destroyed.compareAndSet(false, true)) {
                return;
            }
            DataRepository repo = SaveDataManager.getInstance().getRepository();
            AutoDisconnectMode autoDisMode = repo.getServerData(this.guildId).getAutoDisconnectMode();
            TTSChannelPair ttsChannel = null;
            if (autoDisMode.isReconnect() && (ttsInstance = (ttsManager = ITTSRuntime.getInstance().getTTSManager()).getTTSInstance(this.guildId)) != null) {
                ttsChannel = new TTSChannelPair(ttsInstance.getAudioChannel(), ttsInstance.getTextChannel());
            }
            if ((guild = (jda = ITTSRuntime.getInstance().getBot().getJDA()).getGuildById(this.guildId)) != null) {
                AudioManager audioManager = guild.getAudioManager();
                audioManager.closeAudioConnection();
            }
            if (autoDisMode.isReconnect() && ttsChannel != null) {
                repo.getBotStateData(this.guildId, ITTSRuntime.getInstance().getBot().getBotId()).setReconnectChannelPair(ttsChannel);
            }
            Map<Long, AutoDisconnecter> map = ConnectControl.this.autoDisconnecters;
            synchronized (map) {
                ConnectControl.this.autoDisconnecters.remove(this.guildId);
            }
        }
    }
}

