/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.discord.command.VoiceCommand;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerUserData;
import dev.felnull.itts.core.util.DiscordUtils;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import org.jetbrains.annotations.NotNull;

public class AdminCommand
extends BaseCommand {
    public AdminCommand() {
        super("admin");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"admin", (String)"\u7ba1\u7406\u8005\u5c02\u7528").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(OWNERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("vnick", "\u4ed6\u4eba\u306e\u8aad\u307f\u4e0a\u3052\u30e6\u30fc\u30b6\u540d\u3092\u5909\u66f4").addOptions(new OptionData[]{new OptionData(OptionType.USER, "user", "\u30e6\u30fc\u30b6\u30fc\u6307\u5b9a").setRequired(true)}).addOptions(new OptionData[]{new OptionData(OptionType.STRING, "name", "\u540d\u524d").setRequired(true)})}).addSubcommandGroups(new SubcommandGroupData[]{new SubcommandGroupData("voice", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u95a2\u4fc2").addSubcommands(new SubcommandData[]{new SubcommandData("change", "\u4ed6\u4eba\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u3092\u5909\u66f4").addOptions(new OptionData[]{new OptionData(OptionType.USER, "user", "\u30e6\u30fc\u30b6\u30fc\u6307\u5b9a").setRequired(true)}).addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_category", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u306e\u30ab\u30c6\u30b4\u30ea").setAutoComplete(true).setRequired(true)}).addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_type", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7").setAutoComplete(true).setRequired(true)}), new SubcommandData("check", "\u4ed6\u4eba\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u3092\u78ba\u8a8d").addOptions(new OptionData[]{new OptionData(OptionType.USER, "user", "\u30e6\u30fc\u30b6\u30fc\u6307\u5b9a").setRequired(true)})})});
    }

    @Override
    public void commandInteraction(@NotNull SlashCommandInteractionEvent event) {
        if ("vnick".equals(event.getSubcommandName())) {
            this.vnick(event);
        } else if ("voice".equals(event.getSubcommandGroup())) {
            if ("change".equals(event.getSubcommandName())) {
                this.voiceChange(event);
            } else if ("check".equals(event.getSubcommandName())) {
                this.voiceCheck(event);
            }
        }
    }

    private void vnick(SlashCommandInteractionEvent event) {
        User user = Objects.requireNonNull((User)event.getOption("user", OptionMapping::getAsUser));
        String name = Objects.requireNonNull((String)event.getOption("name", OptionMapping::getAsString));
        Guild guild = Objects.requireNonNull(event.getGuild());
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData sud = legacySaveDataLayer.getServerUserData(guild.getIdLong(), user.getIdLong());
        if ("reset".equals(name)) {
            sud.setNickName(null);
            event.reply(DiscordUtils.getEscapedName(event.getGuild(), user) + "\u306e\u8aad\u307f\u4e0a\u3052\u30e6\u30fc\u30b6\u540d\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            sud.setNickName(name);
            event.reply(DiscordUtils.getEscapedName(event.getGuild(), user) + "\u306e\u8aad\u307f\u4e0a\u3052\u30e6\u30fc\u30b6\u540d\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002").queue();
        }
    }

    private void voiceChange(SlashCommandInteractionEvent event) {
        User user = Objects.requireNonNull((User)event.getOption("user", OptionMapping::getAsUser));
        VoiceCommand.change(event, user);
    }

    private void voiceCheck(SlashCommandInteractionEvent event) {
        User user = Objects.requireNonNull((User)event.getOption("user", OptionMapping::getAsUser));
        VoiceCommand.check(event, user);
    }

    @Override
    public void autoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        if (!"voice".equals(event.getSubcommandGroup()) || !"change".equals(event.getSubcommandName())) {
            return;
        }
        VoiceCommand.voiceSelectComplete(event, null, false);
    }
}

