/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.AutoDisconnectMode;
import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.discord.command.VoiceCommand;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerData;
import dev.felnull.itts.core.savedata.repository.ServerData;
import dev.felnull.itts.core.voice.VoiceCategory;
import dev.felnull.itts.core.voice.VoiceManager;
import dev.felnull.itts.core.voice.VoiceType;
import java.util.Objects;
import java.util.Optional;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import org.jetbrains.annotations.NotNull;

public class ConfigCommand
extends BaseCommand {
    private static final String AUTO_DISCONNECT_NAME = "auto-disconnect";

    public ConfigCommand() {
        super("config");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"config", (String)"\u8a2d\u5b9a").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(OWNERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("notify-move", "VC\u306e\u5165\u9000\u5ba4\u6642\u306b\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u8aad\u307f\u4e0a\u3052").addOptions(new OptionData[]{new OptionData(OptionType.BOOLEAN, "enable", "True: \u6709\u52b9\u3001False: \u7121\u52b9").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("read-limit", "\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650").addOptions(new OptionData[]{new OptionData(OptionType.INTEGER, "max-count", "\u6700\u5927\u6587\u5b57\u6570").setMinValue(1L).setMaxValue(Integer.MAX_VALUE).setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("name-read-limit", "\u540d\u524d\u306e\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650").addOptions(new OptionData[]{new OptionData(OptionType.INTEGER, "max-count", "\u6700\u5927\u6587\u5b57\u6570").setMinValue(1L).setMaxValue(Integer.MAX_VALUE).setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("need-join", "VC\u306b\u53c2\u52a0\u4e2d\u306e\u30e6\u30fc\u30b6\u30fc\u306e\u307f\u8aad\u307f\u4e0a\u3052").addOptions(new OptionData[]{new OptionData(OptionType.BOOLEAN, "enable", "True: \u6709\u52b9\u3001False: \u7121\u52b9").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("read-overwrite", "\u8aad\u307f\u4e0a\u3052\u306e\u4e0a\u66f8\u304d").addOptions(new OptionData[]{new OptionData(OptionType.BOOLEAN, "enable", "True: \u6709\u52b9\u3001False: \u7121\u52b9").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("read-ignore", "\u8aad\u307f\u4e0a\u3052\u306a\u3044\u6587\u5b57").addOptions(new OptionData[]{new OptionData(OptionType.STRING, "regex", "\u6b63\u898f\u8868\u73fe").setMaxLength(100).setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("default-voice", "\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7").addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_category", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u306e\u30ab\u30c6\u30b4\u30ea").setAutoComplete(true).setRequired(true)}).addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_type", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7").setAutoComplete(true).setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData(AUTO_DISCONNECT_NAME, "\u81ea\u52d5\u5207\u65ad").addOptions(new OptionData[]{new OptionData(OptionType.STRING, "mode", "\u30e2\u30fc\u30c9").addChoice(ConfigCommand.getAutoDisconnectModeName(AutoDisconnectMode.OFF), "off").addChoice(ConfigCommand.getAutoDisconnectModeName(AutoDisconnectMode.ON), "on").addChoice(ConfigCommand.getAutoDisconnectModeName(AutoDisconnectMode.ON_RECONNECT), "on_reconnect").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("show", "\u73fe\u5728\u306e\u30b3\u30f3\u30d5\u30a3\u30b0\u3092\u8868\u793a")});
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        switch (Objects.requireNonNull(event.getSubcommandName())) {
            case "notify-move": {
                this.notifyMove(event);
                break;
            }
            case "read-limit": {
                this.readLimit(event);
                break;
            }
            case "name-read-limit": {
                this.nameReadLimit(event);
                break;
            }
            case "need-join": {
                this.needJoin(event);
                break;
            }
            case "read-overwrite": {
                this.readOverwrite(event);
                break;
            }
            case "read-ignore": {
                this.readIgnore(event);
                break;
            }
            case "default-voice": {
                this.defaultVoice(event);
                break;
            }
            case "show": {
                this.show(event);
                break;
            }
            case "auto-disconnect": {
                this.autoDisconnectMode(event);
                break;
            }
        }
    }

    private void show(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        EmbedBuilder showEmbedBuilder = new EmbedBuilder();
        showEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        showEmbedBuilder.setTitle("\u73fe\u5728\u306e\u30b3\u30f3\u30d5\u30a3\u30b0");
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerData sd = legacySaveDataLayer.getServerData(guild.getIdLong());
        VoiceManager vm = this.getVoiceManager();
        VoiceType dv = vm.getDefaultVoiceType(guild.getIdLong());
        ServerData serverData = SaveDataManager.getInstance().getRepository().getServerData(event.getGuild().getIdLong());
        boolean inline = true;
        showEmbedBuilder.addField("VC\u306e\u5165\u9000\u5ba4\u6642\u306b\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u8aad\u307f\u4e0a\u3052", sd.isNotifyMove() ? "\u6709\u52b9" : "\u7121\u52b9", true);
        showEmbedBuilder.addField("\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650", sd.getReadLimit() + "\u6587\u5b57", true);
        showEmbedBuilder.addField("\u540d\u524d\u306e\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650", sd.getNameReadLimit() + "\u6587\u5b57", true);
        showEmbedBuilder.addField("VC\u306b\u53c2\u52a0\u4e2d\u306e\u30e6\u30fc\u30b6\u30fc\u306e\u307f\u8aad\u307f\u4e0a\u3052", sd.isNeedJoin() ? "\u6709\u52b9" : "\u7121\u52b9", true);
        showEmbedBuilder.addField("\u8aad\u307f\u4e0a\u3052\u306e\u4e0a\u66f8\u304d", sd.isOverwriteAloud() ? "\u6709\u52b9" : "\u7121\u52b9", true);
        showEmbedBuilder.addField("\u8aad\u307f\u4e0a\u3052\u306a\u3044\u6587\u5b57(\u6b63\u898f\u8868\u73fe)", (String)(sd.getIgnoreRegex() == null ? "\u7121\u3057" : "``" + sd.getIgnoreRegex() + "``"), true);
        showEmbedBuilder.addField("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7", dv == null ? "\u7121\u3057" : dv.getName(), true);
        showEmbedBuilder.addField("\u81ea\u52d5\u5207\u65ad", ConfigCommand.getAutoDisconnectModeName(serverData.getAutoDisconnectMode()), true);
        event.replyEmbeds(showEmbedBuilder.build(), new MessageEmbed[0]).queue();
    }

    private void defaultVoice(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        String odVc = (String)event.getOption("voice_category", OptionMapping::getAsString);
        String odVt = (String)event.getOption("voice_type", OptionMapping::getAsString);
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerData sd = legacySaveDataLayer.getServerData(guild.getIdLong());
        VoiceManager vm = this.getVoiceManager();
        Optional<VoiceCategory> cat = vm.getVoiceCategory(odVc);
        if (cat.isEmpty()) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8aad\u307f\u4e0a\u3052\u30ab\u30c6\u30b4\u30ea\u30fc\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        Optional<VoiceType> vt = vm.getVoiceType(odVt);
        if (vt.isEmpty()) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        VoiceType pre = vm.getDefaultVoiceType(event.getGuild().getIdLong());
        if (pre == null || !vt.get().getId().equals(pre.getId())) {
            sd.setDefaultVoiceType(vt.get().getId());
            event.reply("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7\u3092" + vt.get().getName() + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7\u306f" + vt.get().getName() + "\u3067\u3059\u3002").queue();
        }
    }

    private void readIgnore(SlashCommandInteractionEvent event) {
        LegacySaveDataLayer legacySaveDataLayer;
        LegacyServerData sd;
        String pre;
        Guild guild = Objects.requireNonNull(event.getGuild());
        String op = Objects.requireNonNull((String)event.getOption("regex", OptionMapping::getAsString));
        if (!op.equals(pre = (sd = (legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer()).getServerData(guild.getIdLong())).getIgnoreRegex())) {
            sd.setIgnoreRegex(op);
            event.reply("\u8aad\u307f\u4e0a\u3052\u306a\u3044\u6587\u5b57\u3092``" + op + "``\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u8aad\u307f\u4e0a\u3052\u306a\u3044\u6587\u5b57\u306f``" + op + "``\u3067\u3059\u3002").queue();
        }
    }

    private void readOverwrite(SlashCommandInteractionEvent event) {
        String enStr;
        Guild guild = Objects.requireNonNull(event.getGuild());
        boolean op = Boolean.TRUE.equals(event.getOption("enable", OptionMapping::getAsBoolean));
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerData sd = legacySaveDataLayer.getServerData(guild.getIdLong());
        boolean pre = sd.isOverwriteAloud();
        String string = enStr = op ? "\u6709\u52b9" : "\u7121\u52b9";
        if (op != pre) {
            sd.setOverwriteAloud(op);
            this.getTTSManager().reload(guild);
            event.reply("\u8aad\u307f\u4e0a\u3052\u306e\u4e0a\u66f8\u304d\u3092" + enStr + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u8aad\u307f\u4e0a\u3052\u306e\u4e0a\u66f8\u304d\u306f" + enStr + "\u3067\u3059\u3002").queue();
        }
    }

    private void needJoin(SlashCommandInteractionEvent event) {
        String enStr;
        Guild guild = Objects.requireNonNull(event.getGuild());
        boolean op = Boolean.TRUE.equals(event.getOption("enable", OptionMapping::getAsBoolean));
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerData sd = legacySaveDataLayer.getServerData(guild.getIdLong());
        boolean pre = sd.isNeedJoin();
        String string = enStr = op ? "\u6709\u52b9" : "\u7121\u52b9";
        if (op != pre) {
            sd.setNeedJoin(op);
            event.reply("VC\u306b\u53c2\u52a0\u4e2d\u306e\u30e6\u30fc\u30b6\u30fc\u306e\u307f\u8aad\u307f\u4e0a\u3052\u3092" + enStr + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306bVC\u306b\u53c2\u52a0\u4e2d\u306e\u30e6\u30fc\u30b6\u30fc\u306e\u307f\u8aad\u307f\u4e0a\u3052\u306f" + enStr + "\u3067\u3059\u3002").queue();
        }
    }

    private void nameReadLimit(SlashCommandInteractionEvent event) {
        LegacySaveDataLayer legacySaveDataLayer;
        LegacyServerData sd;
        int pre;
        Guild guild = Objects.requireNonNull(event.getGuild());
        int op = Objects.requireNonNullElse((Integer)event.getOption("max-count", OptionMapping::getAsInt), 0);
        if (op != (pre = (sd = (legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer()).getServerData(guild.getIdLong())).getNameReadLimit())) {
            sd.setNameReadLimit(op);
            event.reply("\u540d\u524d\u306e\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650\u3092" + op + "\u6587\u5b57\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u540d\u524d\u306e\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650\u306f" + op + "\u6587\u5b57\u3067\u3059\u3002").queue();
        }
    }

    private void readLimit(SlashCommandInteractionEvent event) {
        LegacySaveDataLayer legacySaveDataLayer;
        LegacyServerData sd;
        int pre;
        Guild guild = Objects.requireNonNull(event.getGuild());
        int op = Objects.requireNonNullElse((Integer)event.getOption("max-count", OptionMapping::getAsInt), 0);
        if (op != (pre = (sd = (legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer()).getServerData(guild.getIdLong())).getReadLimit())) {
            sd.setReadLimit(op);
            event.reply("\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650\u3092" + op + "\u6587\u5b57\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\u4e0a\u9650\u306f" + op + "\u6587\u5b57\u3067\u3059\u3002").queue();
        }
    }

    private void notifyMove(SlashCommandInteractionEvent event) {
        String enStr;
        Guild guild = Objects.requireNonNull(event.getGuild());
        OptionMapping op = Objects.requireNonNull(event.getOption("enable"));
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerData sd = legacySaveDataLayer.getServerData(guild.getIdLong());
        boolean pre = sd.isNotifyMove();
        String string = enStr = op.getAsBoolean() ? "\u6709\u52b9" : "\u7121\u52b9";
        if (op.getAsBoolean() != pre) {
            sd.setNotifyMove(op.getAsBoolean());
            event.reply("VC\u306e\u5165\u9000\u5ba4\u6642\u306b\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u8aad\u307f\u4e0a\u3052\u3092" + enStr + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306bVC\u306e\u5165\u9000\u5ba4\u6642\u306b\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u8aad\u307f\u4e0a\u3052\u306f" + enStr + "\u3067\u3059\u3002").queue();
        }
    }

    private void autoDisconnectMode(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        OptionMapping op = Objects.requireNonNull(event.getOption("mode"));
        AutoDisconnectMode mode = switch (op.getAsString()) {
            case "off" -> AutoDisconnectMode.OFF;
            case "on" -> AutoDisconnectMode.ON;
            case "on_reconnect" -> AutoDisconnectMode.ON_RECONNECT;
            default -> throw new IllegalStateException("Unexpected value: " + op.getAsString());
        };
        ServerData serverData = SaveDataManager.getInstance().getRepository().getServerData(guild.getIdLong());
        AutoDisconnectMode preModel = serverData.getAutoDisconnectMode();
        String name = ConfigCommand.getAutoDisconnectModeName(mode);
        if (mode != preModel) {
            serverData.setAutoDisconnectMode(mode);
            this.getBot().getConnectControl().updateAutoDisconnectMode(guild.getIdLong());
            event.reply("\u81ea\u52d5\u5207\u65ad\u3092" + name + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
        } else {
            event.reply("\u65e2\u306b\u81ea\u52d5\u5207\u65ad\u306f" + name + "\u3067\u3059\u3002").queue();
        }
    }

    private static String getAutoDisconnectModeName(AutoDisconnectMode autoDisconnectMode) {
        return switch (autoDisconnectMode) {
            case AutoDisconnectMode.OFF -> "\u7121\u52b9";
            case AutoDisconnectMode.ON -> "\u6709\u52b9";
            case AutoDisconnectMode.ON_RECONNECT -> "\u6709\u52b9 (\u518d\u63a5\u7d9a)";
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(autoDisconnectMode));
        };
    }

    @Override
    public void autoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        Objects.requireNonNull(event.getGuild());
        CommandAutoCompleteInteraction interact = event.getInteraction();
        if (!"default-voice".equals(interact.getSubcommandName())) {
            return;
        }
        VoiceCommand.voiceSelectComplete(event, null, false);
    }
}

