/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerUserData;
import dev.felnull.itts.core.util.DiscordUtils;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import org.jetbrains.annotations.NotNull;

public class DenyCommand
extends BaseCommand {
    public DenyCommand() {
        super("deny");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"deny", (String)"\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u95a2\u4fc2").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(OWNERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("add", "\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u30ea\u30b9\u30c8\u306b\u30e6\u30fc\u30b6\u30fc\u3092\u8ffd\u52a0").addOptions(new OptionData[]{new OptionData(OptionType.USER, "user", "\u30e6\u30fc\u30b6\u30fc\u6307\u5b9a").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("remove", "\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u30ea\u30b9\u30c8\u304b\u3089\u30e6\u30fc\u30b6\u30fc\u3092\u524a\u9664").addOptions(new OptionData[]{new OptionData(OptionType.USER, "user", "\u30e6\u30fc\u30b6\u30fc\u6307\u5b9a").setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("show", "\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u30ea\u30b9\u30c8\u3092\u8868\u793a")});
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        switch (Objects.requireNonNull(event.getSubcommandName())) {
            case "add": {
                this.add(event);
                break;
            }
            case "remove": {
                this.remove(event);
                break;
            }
            case "show": {
                this.show(event);
                break;
            }
        }
    }

    private void remove(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        User user = Objects.requireNonNull((User)event.getOption("user", OptionMapping::getAsUser));
        if (user.isBot()) {
            event.reply(DiscordUtils.getEscapedName(guild, user) + "\u306fBOT\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData sud = legacySaveDataLayer.getServerUserData(guild.getIdLong(), event.getUser().getIdLong());
        if (!sud.isDeny()) {
            event.reply("\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3092\u3055\u308c\u3066\u3044\u306a\u3044\u30e6\u30fc\u30b6\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        sud.setDeny(false);
        event.reply(DiscordUtils.getEscapedName(guild, user) + "\u306e\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3092\u89e3\u9664\u3057\u307e\u3059\u3002").setEphemeral(true).queue();
    }

    private void show(SlashCommandInteractionEvent event) {
        Guild guild;
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        List<Long> denyUsers = legacySaveDataLayer.getAllDenyUser((guild = Objects.requireNonNull(event.getGuild())).getIdLong());
        if (denyUsers.isEmpty()) {
            event.reply("\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3055\u308c\u305f\u30e6\u30fc\u30b6\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002").setEphemeral(true).queue();
            return;
        }
        MessageCreateBuilder msg = new MessageCreateBuilder().addContent("\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3055\u308c\u305f\u30e6\u30fc\u30b6\u4e00\u89a7\n");
        StringBuilder sb = new StringBuilder();
        for (Long deny : denyUsers) {
            sb.append(DiscordUtils.getEscapedName(guild, Objects.requireNonNull(event.getJDA().getUserById(deny.longValue())))).append("\n");
        }
        msg.addContent("``" + String.valueOf(sb) + "``");
        event.reply(msg.build()).setEphemeral(true).queue();
    }

    private void add(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        User user = (User)event.getOption("user", OptionMapping::getAsUser);
        Objects.requireNonNull(user);
        if (user.isBot()) {
            event.reply(DiscordUtils.getEscapedName(guild, user) + "\u306fBOT\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData sud = legacySaveDataLayer.getServerUserData(guild.getIdLong(), event.getUser().getIdLong());
        if (sud.isDeny()) {
            event.reply("\u3059\u3067\u306b\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3092\u3055\u308c\u3066\u3044\u308b\u30e6\u30fc\u30b6\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        sud.setDeny(true);
        event.reply(DiscordUtils.getEscapedName(guild, user) + "\u306e\u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3057\u307e\u3059\u3002").setEphemeral(true).queue();
    }
}

