/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.tts.TTSManager;
import java.util.Objects;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponent;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import org.jetbrains.annotations.NotNull;

public class InfoCommand
extends BaseCommand {
    private static final String SOURCE_URL = "https://github.com/TeamFelnull/I-TTS";
    private static final String RELATIVE_TIME_FORMAT = "<t:%d:R>";

    public InfoCommand() {
        super("info");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"info", (String)"\u60c5\u5831\u3092\u8868\u793a").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(MEMBERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("about", "BOT\u60c5\u5831\u3092\u8868\u793a")}).addSubcommands(new SubcommandData[]{new SubcommandData("oss", "OSS\u60c5\u5831\u3092\u8868\u793a")}).addSubcommands(new SubcommandData[]{new SubcommandData("work", "\u7a3c\u50cd\u60c5\u5831\u3092\u8868\u793a")});
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        switch (Objects.requireNonNull(event.getSubcommandName())) {
            case "about": {
                this.about(event);
                break;
            }
            case "oss": {
                this.oss(event);
                break;
            }
            case "work": {
                this.work(event);
                break;
            }
        }
    }

    private void about(SlashCommandInteractionEvent e) {
        EmbedBuilder aboutEmbedBuilder = new EmbedBuilder();
        aboutEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        aboutEmbedBuilder.setTitle("Ikisugi TTS BOT");
        aboutEmbedBuilder.setDescription((CharSequence)this.getITTSRuntime().getVersionText());
        aboutEmbedBuilder.addField("License", "GNU LGPLv3", false);
        aboutEmbedBuilder.setFooter("Developed by FelNull", "https://avatars.githubusercontent.com/u/59995376?s=200&v=4");
        try (MessageCreateData messageCreateData = ((MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(new MessageEmbed[]{aboutEmbedBuilder.build()})).addComponents(new MessageTopLevelComponent[]{ActionRow.of((ActionRowChildComponent)Button.of((ButtonStyle)ButtonStyle.LINK, (String)SOURCE_URL, (String)"Source"), (ActionRowChildComponent[])new ActionRowChildComponent[0])})).build();){
            e.reply(messageCreateData).setEphemeral(true).queue();
        }
    }

    private void oss(SlashCommandInteractionEvent e) {
        EmbedBuilder ossEmbedBuilder = new EmbedBuilder();
        ossEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        ossEmbedBuilder.setTitle("OSS\u30af\u30ec\u30b8\u30c3\u30c8");
        ossEmbedBuilder.addField("VOICEVOX", "voicevox.hiroshiba.jp", false);
        ossEmbedBuilder.addField("COEIROINK", "coeiroink.com", false);
        ossEmbedBuilder.addField("SHAREVOX", "sharevox.app", false);
        ossEmbedBuilder.addField("VoiceTextWebAPI", "cloud.voicetext.jp", false);
        e.replyEmbeds(ossEmbedBuilder.build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    private void work(SlashCommandInteractionEvent e) {
        TTSManager ttsManager = this.getTTSManager();
        EmbedBuilder workEmbedBuilder = new EmbedBuilder();
        workEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        workEmbedBuilder.setTitle("\u7a3c\u50cd\u60c5\u5831");
        workEmbedBuilder.addField("\u7a3c\u50cd\u958b\u59cb\u6642\u9593", String.format(RELATIVE_TIME_FORMAT, this.getITTSRuntime().getStartupTime() / 1000L), false);
        workEmbedBuilder.addField("\u53c2\u52a0\u30b5\u30fc\u30d0\u30fc\u6570", e.getJDA().getGuilds().size() + "\u500b", false);
        workEmbedBuilder.addField("\u8aad\u307f\u4e0a\u3052\u30b5\u30fc\u30d0\u30fc\u6570", ttsManager.getTTSCount() + "\u500b", false);
        workEmbedBuilder.addField("\u5229\u7528\u8005\u6570", ttsManager.getUserCount() + "\u4eba", false);
        e.replyEmbeds(workEmbedBuilder.build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }
}

