/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.managers.AudioManager;
import org.jetbrains.annotations.NotNull;

public class LeaveCommand
extends BaseCommand {
    public LeaveCommand() {
        super("leave");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"leave", (String)"\u8aad\u307f\u4e0a\u3052BOT\u3092VC\u304b\u3089\u5207\u65ad").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(MEMBERS_PERMISSIONS);
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        AudioManager audioManager = guild.getAudioManager();
        if (audioManager.isConnected()) {
            AudioChannelUnion connectedChannel = audioManager.getConnectedChannel();
            if (connectedChannel != null) {
                event.reply(connectedChannel.getAsMention() + "\u304b\u3089\u5207\u65ad\u3057\u307e\u3059\u3002").queue();
                audioManager.closeAudioConnection();
            } else {
                event.reply("\u5207\u65ad\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002").queue();
            }
        } else {
            VoiceChannel audioChannel;
            boolean reconnectFlg = false;
            DataRepository repo = SaveDataManager.getInstance().getRepository();
            BotStateData botStateData = repo.getBotStateData(guild.getIdLong(), this.getBot().getBotId());
            TTSChannelPair reconnectChannelPair = botStateData.getReconnectChannelPair();
            if (reconnectChannelPair != null && (audioChannel = event.getJDA().getVoiceChannelById(reconnectChannelPair.speakAudioChannel())) != null) {
                event.reply(audioChannel.getAsMention() + "\u304b\u3089\u5207\u65ad\u3057\u307e\u3059\u3002").queue();
                botStateData.setReconnectChannelPair(null);
                reconnectFlg = true;
            }
            if (!reconnectFlg) {
                event.reply("\u73fe\u5728VC\u306b\u63a5\u7d9a\u3057\u3066\u3044\u307e\u305b\u3093\u3002").setEphemeral(true).queue();
            }
        }
    }
}

