/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerUserData;
import dev.felnull.itts.core.util.DiscordUtils;
import dev.felnull.itts.core.util.StringUtils;
import dev.felnull.itts.core.voice.VoiceCategory;
import dev.felnull.itts.core.voice.VoiceManager;
import dev.felnull.itts.core.voice.VoiceType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.InteractionContextType;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import org.jetbrains.annotations.NotNull;

public class VoiceCommand
extends BaseCommand {
    public VoiceCommand() {
        super("voice");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"voice", (String)"\u81ea\u5206\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u95a2\u4fc2").setContexts(new InteractionContextType[]{InteractionContextType.GUILD}).setDefaultPermissions(MEMBERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("change", "\u81ea\u5206\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u3092\u5909\u66f4").addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_category", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u306e\u30ab\u30c6\u30b4\u30ea").setAutoComplete(true).setRequired(true)}).addOptions(new OptionData[]{new OptionData(OptionType.STRING, "voice_type", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7").setAutoComplete(true).setRequired(true)})}).addSubcommands(new SubcommandData[]{new SubcommandData("check", "\u81ea\u5206\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u3092\u78ba\u8a8d")}).addSubcommands(new SubcommandData[]{new SubcommandData("show", "\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u4e00\u89a7\u3092\u8868\u793a")});
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        switch (Objects.requireNonNull(event.getSubcommandName())) {
            case "change": {
                VoiceCommand.change(event, null);
                break;
            }
            case "check": {
                VoiceCommand.check(event, null);
                break;
            }
            case "show": {
                this.show(event);
                break;
            }
        }
    }

    private void show(SlashCommandInteractionEvent event) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        EmbedBuilder showEmbedBuilder = new EmbedBuilder();
        showEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        showEmbedBuilder.setTitle("\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u4e00\u89a7");
        VoiceManager vm = this.getVoiceManager();
        VoiceType currentVt = vm.getVoiceType(guild.getIdLong(), event.getUser().getIdLong());
        VoiceType defaultVt = vm.getDefaultVoiceType(event.getGuild().getIdLong());
        Map<VoiceCategory, List<VoiceType>> catAndTypes = vm.getAvailableVoiceTypes();
        catAndTypes.forEach((cat, types) -> {
            StringBuilder typeText = new StringBuilder();
            for (VoiceType type : types) {
                Object name = type.getName();
                if (defaultVt != null && type.getId().equals(defaultVt.getId())) {
                    name = (String)name + " [\u30c7\u30d5\u30a9\u30eb\u30c8]";
                }
                if (currentVt != null && type.getId().equals(currentVt.getId())) {
                    name = (String)name + " [\u4f7f\u7528\u4e2d]";
                }
                typeText.append((String)name).append("\n");
            }
            showEmbedBuilder.addField(cat.getName(), typeText.toString(), false);
        });
        event.replyEmbeds(showEmbedBuilder.build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    protected static void change(SlashCommandInteractionEvent event, User user) {
        boolean mine;
        Guild guild = Objects.requireNonNull(event.getGuild());
        boolean bl = mine = user == null;
        if (mine) {
            user = event.getUser();
        }
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData serverUserData = legacySaveDataLayer.getServerUserData(guild.getIdLong(), user.getIdLong());
        OptionMapping odVc = Objects.requireNonNull(event.getOption("voice_category"));
        OptionMapping odVt = Objects.requireNonNull(event.getOption("voice_type"));
        VoiceManager vm = ITTSRuntime.getInstance().getVoiceManager();
        Optional<VoiceCategory> cat = vm.getVoiceCategory(odVc.getAsString());
        if (cat.isEmpty()) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8aad\u307f\u4e0a\u3052\u30ab\u30c6\u30b4\u30ea\u30fc\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        Optional<VoiceType> vt = vm.getVoiceType(odVt.getAsString());
        if (vt.isEmpty()) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        if (vt.get().getId().equals(serverUserData.getVoiceType())) {
            event.reply("\u81ea\u5206\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u306f\u5909\u66f4\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002").setEphemeral(true).queue();
            return;
        }
        serverUserData.setVoiceType(vt.get().getId());
        String userName = mine ? "\u81ea\u5206" : DiscordUtils.getEscapedName(guild, user);
        event.reply(userName + "\u306e\u8aad\u307f\u4e0a\u3052\u97f3\u58f0\u30bf\u30a4\u30d7\u3092" + vt.get().getName() + "\u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002").setEphemeral(mine).queue();
    }

    protected static void check(SlashCommandInteractionEvent event, User user) {
        boolean mine;
        Guild guild = Objects.requireNonNull(event.getGuild());
        boolean bl = mine = user == null;
        if (mine) {
            user = event.getUser();
        }
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData serverUserData = legacySaveDataLayer.getServerUserData(guild.getIdLong(), user.getIdLong());
        VoiceManager vm = ITTSRuntime.getInstance().getVoiceManager();
        Optional<VoiceType> vt = vm.getVoiceType(serverUserData.getVoiceType());
        String type = vt.map(VoiceType::getName).orElseGet(() -> {
            VoiceType dvt = vm.getDefaultVoiceType(guild.getIdLong());
            if (dvt != null) {
                return dvt.getName() + " [\u30c7\u30d5\u30a9\u30eb\u30c8]";
            }
            return "\u7121\u52b9";
        });
        String userName = mine ? "\u81ea\u5206" : DiscordUtils.getEscapedName(guild, user);
        event.reply(userName + "\u306e\u73fe\u5728\u306e\u8aad\u307f\u4e0a\u3052\u30bf\u30a4\u30d7\u306f" + type + "\u3067\u3059\u3002").setEphemeral(mine).queue();
    }

    @Override
    public void autoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        Objects.requireNonNull(event.getGuild());
        CommandAutoCompleteInteraction interact = event.getInteraction();
        if (!"change".equals(interact.getSubcommandName())) {
            return;
        }
        VoiceCommand.voiceSelectComplete(event, null, true);
    }

    protected static void voiceSelectComplete(CommandAutoCompleteInteractionEvent event, User user, boolean showUsed) {
        Guild guild = Objects.requireNonNull(event.getGuild());
        if (user == null) {
            user = event.getUser();
        }
        CommandAutoCompleteInteraction interact = event.getInteraction();
        AutoCompleteQuery fcs = interact.getFocusedOption();
        String val = fcs.getValue();
        VoiceManager vm = ITTSRuntime.getInstance().getVoiceManager();
        Map<VoiceCategory, List<VoiceType>> catAndTypes = vm.getAvailableVoiceTypes();
        if ("voice_category".equals(fcs.getName())) {
            event.replyChoices(catAndTypes.keySet().stream().sorted(Comparator.comparingInt(cat -> -StringUtils.getComplementPoint(cat.getName(), val))).limit(25L).map(cat -> new Command.Choice(cat.getName(), cat.getId())).toList()).queue();
        } else if ("voice_type".equals(fcs.getName())) {
            VoiceType currentVt = showUsed ? vm.getVoiceType(guild.getIdLong(), user.getIdLong()) : null;
            VoiceType defaultVt = vm.getDefaultVoiceType(guild.getIdLong());
            Optional<List> cat2 = Optional.ofNullable(event.getOption("voice_category")).flatMap(catOp -> vm.getVoiceCategory(catOp.getAsString()));
            event.replyChoices((Collection)cat2.map(catAndTypes::get).map(vts -> vts.stream().sorted(Comparator.comparingInt(vt -> -StringUtils.getComplementPoint(vt.getName(), val))).limit(25L).map(vt -> {
                Object name = vt.getName();
                if (defaultVt != null && vt.getId().equals(defaultVt.getId())) {
                    name = (String)name + " [\u30c7\u30d5\u30a9\u30eb\u30c8]";
                }
                if (showUsed && currentVt != null && vt.getId().equals(currentVt.getId())) {
                    name = (String)name + " [\u4f7f\u7528\u4e2d]";
                }
                return new Command.Choice((String)name, vt.getId());
            }).toList()).orElseGet(ImmutableList::of)).queue();
        }
    }
}

