/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata;

import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.config.DataBaseConfig;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.DAOFactory;
import dev.felnull.itts.core.savedata.legacy.LegacyMigrator;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.savedata.repository.RepoErrorListener;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SaveDataManager {
    private static final SaveDataManager INSTANCE = new SaveDataManager();
    private static final Logger LOGGER = LogManager.getLogger(SaveDataManager.class);
    private static final File SQLITE_DB_FILE = new File("./save_data.db");
    private static final int REPO_REGEN_NUM_OF_ERROR = 5;
    private final LegacySaveDataLayer legacySaveDataLayer = LegacySaveDataLayer.create(this);
    private final AtomicReference<DataRepository> repository = new AtomicReference();
    private final RepoErrorListener errorListener = this::onRepoError;
    private final AtomicInteger errorCounter = new AtomicInteger();
    private final Object repRecreateLock = new Object();
    private RepoRecreateTask repoRecreateTask;

    private SaveDataManager() {
    }

    public static SaveDataManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        LegacyMigrator.checkAndExecution(this::createDAO);
        DataRepository repo = DataRepository.create(this.createDAO());
        repo.init();
        repo.addErrorListener(this.errorListener);
        this.repository.set(repo);
    }

    private DAO createDAO() {
        DataBaseConfig dataBaseConfig = ITTSRuntime.getInstance().getConfigManager().getConfig().getDataBaseConfig();
        return switch (dataBaseConfig.getType()) {
            case DataBaseConfig.DataBaseType.SQLITE -> DAOFactory.getInstance().createSQLiteDAO(SQLITE_DB_FILE);
            case DataBaseConfig.DataBaseType.MYSQL -> DAOFactory.getInstance().createMysqlDAO(dataBaseConfig.getHost(), dataBaseConfig.getPort(), dataBaseConfig.getDatabaseName(), dataBaseConfig.getUser(), dataBaseConfig.getPassword());
            default -> throw new IllegalStateException("Unsupported type: " + String.valueOf(dataBaseConfig.getType()));
        };
    }

    public LegacySaveDataLayer getLegacySaveDataLayer() {
        return this.legacySaveDataLayer;
    }

    @NotNull
    public DataRepository getRepository() {
        DataRepository repo = this.repository.get();
        if (repo == null) {
            this.tryRepRecreate();
            throw new RuntimeException("The repository is currently being prepared");
        }
        return repo;
    }

    private void onRepoError(Throwable throwable) {
        if (this.errorCounter.incrementAndGet() >= 5) {
            this.tryRepRecreate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRepRecreate() {
        Object object = this.repRecreateLock;
        synchronized (object) {
            if (this.repoRecreateTask == null) {
                this.repoRecreateTask = new RepoRecreateTask();
                this.repoRecreateTask.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRepRecreate() {
        Object object = this.repRecreateLock;
        synchronized (object) {
            if (this.repoRecreateTask != null) {
                this.repoRecreateTask = null;
            }
        }
    }

    private final class RepoRecreateTask {
        private RepoRecreateTask() {
        }

        private void start() {
            try {
                DataRepository repo = SaveDataManager.this.repository.getAndSet(null);
                if (repo != null) {
                    repo.removeErrorListener(SaveDataManager.this.errorListener);
                    repo.dispose();
                }
                CompletableFuture.supplyAsync(() -> {
                    DataRepository ret = DataRepository.create(SaveDataManager.this.createDAO());
                    ret.init();
                    ret.addErrorListener(SaveDataManager.this.errorListener);
                    return ret;
                }, ITTSRuntime.getInstance().getAsyncWorkerExecutor()).whenCompleteAsync((dataRepository, throwable) -> {
                    if (throwable == null) {
                        SaveDataManager.this.repository.set((DataRepository)dataRepository);
                        LOGGER.info("Repository was reloaded");
                    } else {
                        LOGGER.error("Failed to load repository", throwable);
                    }
                    SaveDataManager.this.finishRepRecreate();
                }, ITTSRuntime.getInstance().getAsyncWorkerExecutor());
            }
            catch (Throwable throwable2) {
                LOGGER.error("Repository recreation task failed to start");
                SaveDataManager.this.finishRepRecreate();
            }
        }
    }
}

