/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.dao;

import dev.felnull.itts.core.dict.DictionaryUseEntry;
import dev.felnull.itts.core.savedata.dao.BotStateDataRecord;
import dev.felnull.itts.core.savedata.dao.DictionaryRecord;
import dev.felnull.itts.core.savedata.dao.DictionaryUseDataRecord;
import dev.felnull.itts.core.savedata.dao.IdRecordPair;
import dev.felnull.itts.core.savedata.dao.ServerBotKey;
import dev.felnull.itts.core.savedata.dao.ServerDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerDictionaryKey;
import dev.felnull.itts.core.savedata.dao.ServerKey;
import dev.felnull.itts.core.savedata.dao.ServerUserDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerUserKey;
import dev.felnull.itts.core.savedata.dao.TTSChannelKeyPair;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface DAO {
    public void init();

    public void dispose();

    public Connection getConnection() throws SQLException;

    public ServerKeyTable serverKeyTable();

    public UserKeyTable userKeyTable();

    public BotKeyTable botKeyTable();

    public ChannelKeyTable channelKeyTable();

    public DictionaryKeyTable dictionaryKeyTable();

    public DictionaryReplaceTypeKeyTable dictionaryReplaceTypeKeyTable();

    public AutoDisconnectModeKeyTable autoDisconnectModeKeyTable();

    public VoiceTypeKeyTable voiceTypeKeyTable();

    public ServerDataTable serverDataTable();

    public ServerUserDataTable serverUserDataTable();

    public DictionaryUseDataTable dictionaryUseDataTable();

    public BotStateDataTable botStateDataTable();

    public ServerCustomDictionaryTable serverCustomDictionaryTable();

    public GlobalCustomDictionaryTable globalCustomDictionaryTable();

    public boolean checkEmojiSupport();

    public static interface GlobalCustomDictionaryTable
    extends Table {
        public @Unmodifiable Map<Integer, DictionaryRecord> selectRecords(Connection var1) throws SQLException;

        public void insertRecord(Connection var1, @NotNull DictionaryRecord var2) throws SQLException;

        public void deleteRecord(Connection var1, int var2) throws SQLException;

        public Map<Integer, DictionaryRecord> selectRecordByTarget(Connection var1, @NotNull String var2) throws SQLException;
    }

    public static interface ServerCustomDictionaryTable
    extends Table {
        public @Unmodifiable Map<Integer, DictionaryRecord> selectRecords(Connection var1, @NotNull ServerKey var2) throws SQLException;

        public void insertRecord(Connection var1, @NotNull ServerKey var2, @NotNull DictionaryRecord var3) throws SQLException;

        public void deleteRecord(Connection var1, int var2) throws SQLException;

        public Map<Integer, DictionaryRecord> selectRecordByTarget(Connection var1, @NotNull ServerKey var2, @NotNull String var3) throws SQLException;
    }

    public static interface BotStateDataTable
    extends DataTable<ServerBotKey, BotStateDataRecord> {
        public Optional<TTSChannelKeyPair> selectConnectedChannelKeyPair(Connection var1, int var2) throws SQLException;

        public void updateConnectedChannelKeyPair(Connection var1, int var2, @Nullable TTSChannelKeyPair var3) throws SQLException;

        public Optional<TTSChannelKeyPair> selectReconnectChannelKeyPair(Connection var1, int var2) throws SQLException;

        public void updateReconnectChannelKeyPair(Connection var1, int var2, @Nullable TTSChannelKeyPair var3) throws SQLException;

        public Map<Long, TTSChannelPair> selectAllConnectedChannelPairByBotKeyId(Connection var1, int var2) throws SQLException;

        public OptionalInt selectSpeakAudioChannel(Connection var1, int var2) throws SQLException;

        public void updateSpeakAudioChannel(Connection var1, int var2, Integer var3) throws SQLException;

        public OptionalInt selectReadAroundTextChannel(Connection var1, int var2) throws SQLException;

        public void updateReadAroundTextChannel(Connection var1, int var2, Integer var3) throws SQLException;

        public List<Long> selectAll(Connection var1, int var2) throws SQLException;
    }

    public static interface DictionaryUseDataTable
    extends DataTable<ServerDictionaryKey, DictionaryUseDataRecord> {
        public Optional<Boolean> selectEnable(Connection var1, int var2) throws SQLException;

        public void updateEnable(Connection var1, int var2, @Nullable Boolean var3) throws SQLException;

        public OptionalInt selectPriority(Connection var1, int var2) throws SQLException;

        public void updatePriority(Connection var1, int var2, @Nullable Integer var3) throws SQLException;

        public List<DictionaryUseEntry> selectAll(Connection var1, int var2) throws SQLException;
    }

    public static interface ServerUserDataTable
    extends DataTable<ServerUserKey, ServerUserDataRecord> {
        public OptionalInt selectVoiceType(Connection var1, int var2) throws SQLException;

        public void updateVoiceType(Connection var1, int var2, @Nullable Integer var3) throws SQLException;

        public boolean selectDeny(Connection var1, int var2) throws SQLException;

        public void updateDeny(Connection var1, int var2, boolean var3) throws SQLException;

        public Optional<String> selectNickName(Connection var1, int var2) throws SQLException;

        public void updateNickName(Connection var1, int var2, @Nullable String var3) throws SQLException;

        public List<Long> selectAllDenyUser(Connection var1, int var2) throws SQLException;
    }

    public static interface ServerDataTable
    extends DataTable<ServerKey, ServerDataRecord> {
        public OptionalInt selectDefaultVoiceType(Connection var1, int var2) throws SQLException;

        public void updateDefaultVoiceType(Connection var1, int var2, @Nullable Integer var3) throws SQLException;

        public Optional<String> selectIgnoreRegex(Connection var1, int var2) throws SQLException;

        public void updateIgnoreRegex(Connection var1, int var2, @Nullable String var3) throws SQLException;

        public boolean selectNeedJoin(Connection var1, int var2) throws SQLException;

        public void updateNeedJoin(Connection var1, int var2, boolean var3) throws SQLException;

        public boolean selectOverwriteAloud(Connection var1, int var2) throws SQLException;

        public void updateOverwriteAloud(Connection var1, int var2, boolean var3) throws SQLException;

        public boolean selectNotifyMove(Connection var1, int var2) throws SQLException;

        public void updateNotifyMove(Connection var1, int var2, boolean var3) throws SQLException;

        public int selectReadLimit(Connection var1, int var2) throws SQLException;

        public void updateReadLimit(Connection var1, int var2, int var3) throws SQLException;

        public int selectNameReadLimit(Connection var1, int var2) throws SQLException;

        public void updateNameReadLimit(Connection var1, int var2, int var3) throws SQLException;

        public int selectAutoDisconnectMode(Connection var1, int var2) throws SQLException;

        public void updateAutoDisconnectMode(Connection var1, int var2, int var3) throws SQLException;
    }

    public static interface DataTable<K extends Record, T extends Record>
    extends Table {
        public void insertRecordIfNotExists(@NotNull Connection var1, @NotNull K var2, @NotNull T var3) throws SQLException;

        public Optional<IdRecordPair<T>> selectRecordByKey(@NotNull Connection var1, @NotNull K var2) throws SQLException;

        public Optional<T> selectRecordById(@NotNull Connection var1, int var2) throws SQLException;
    }

    public static interface VoiceTypeKeyTable
    extends KeyTable<String> {
    }

    public static interface AutoDisconnectModeKeyTable
    extends KeyTable<String> {
    }

    public static interface DictionaryReplaceTypeKeyTable
    extends KeyTable<String> {
    }

    public static interface DictionaryKeyTable
    extends KeyTable<String> {
    }

    public static interface ChannelKeyTable
    extends KeyTable<Long> {
    }

    public static interface BotKeyTable
    extends KeyTable<Long> {
    }

    public static interface UserKeyTable
    extends KeyTable<Long> {
    }

    public static interface ServerKeyTable
    extends KeyTable<Long> {
    }

    public static interface KeyTable<T>
    extends Table {
        public OptionalInt selectId(@NotNull Connection var1, @NotNull T var2) throws SQLException;

        public Optional<T> selectKey(@NotNull Connection var1, int var2) throws SQLException;

        public void insertKeyIfNotExists(@NotNull Connection var1, @NotNull T var2) throws SQLException;
    }

    public static interface Table {
        public void createTableIfNotExists(@NotNull Connection var1) throws SQLException;
    }
}

