/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.dao.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.felnull.itts.core.dict.DictionaryUseEntry;
import dev.felnull.itts.core.savedata.dao.BotStateDataRecord;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.DictionaryRecord;
import dev.felnull.itts.core.savedata.dao.DictionaryUseDataRecord;
import dev.felnull.itts.core.savedata.dao.IdRecordPair;
import dev.felnull.itts.core.savedata.dao.ServerBotKey;
import dev.felnull.itts.core.savedata.dao.ServerDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerDictionaryKey;
import dev.felnull.itts.core.savedata.dao.ServerKey;
import dev.felnull.itts.core.savedata.dao.ServerUserDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerUserKey;
import dev.felnull.itts.core.savedata.dao.TTSChannelKeyPair;
import dev.felnull.itts.core.savedata.dao.impl.BaseDAO;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class MySQLDAO
extends BaseDAO {
    private final DAO.ServerKeyTable serverKeyTable = new ServerKeyTableImpl();
    private final DAO.UserKeyTable userKeyTable = new UserKeyTableImpl();
    private final DAO.BotKeyTable botKeyTable = new BotKeyTableImpl();
    private final DAO.ChannelKeyTable channelKeyTable = new ChannelKeyTableImpl();
    private final DAO.DictionaryKeyTable dictionaryKeyTable = new DictionaryKeyTableImpl();
    private final DAO.DictionaryReplaceTypeKeyTable dictionaryReplaceTypeKeyTable = new DictionaryReplaceTypeKeyTableImpl();
    private final DAO.AutoDisconnectModeKeyTable autoDisconnectModeKeyTable = new AutoDisconnectModeKeyTableImpl();
    private final DAO.VoiceTypeKeyTable voiceTypeKeyTable = new VoiceTypeKeyTableImpl();
    private final DAO.ServerDataTable serverDataTable = new ServerDataTableImpl();
    private final DAO.ServerUserDataTable serverUserDataTable = new ServerUserDataTableImpl();
    private final DAO.DictionaryUseDataTable dictionaryUseDataTable = new DictionaryUseDataTableImpl();
    private final DAO.BotStateDataTable botStateDataTable = new BotStateDataTableImpl();
    private final DAO.ServerCustomDictionaryTable serverCustomDictionaryTable = new ServerCustomDictionaryTableImpl();
    private final DAO.GlobalCustomDictionaryTable globalCustomDictionaryTable = new GlobalCustomDictionaryTableImpl();
    private final String host;
    private final int port;
    private final String databaseName;
    private final String user;
    private final String password;

    MySQLDAO(String host, int port, String databaseName, String user, String password) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.user = user;
        this.password = password;
    }

    @Override
    protected HikariDataSource createDataSource() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("I-TTS Pool");
        config.setConnectionTestQuery("SELECT 1");
        config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        config.setJdbcUrl(String.format("jdbc:mysql://%s:%d/%s", this.host, this.port, this.databaseName));
        config.setUsername(this.user);
        config.setPassword(this.password);
        return new HikariDataSource(config);
    }

    private void execute(@NotNull Connection connection, @NotNull @Language(value="MySQL") String sql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.execute();
        }
    }

    @Override
    public DAO.ServerKeyTable serverKeyTable() {
        return this.serverKeyTable;
    }

    @Override
    public DAO.UserKeyTable userKeyTable() {
        return this.userKeyTable;
    }

    @Override
    public DAO.BotKeyTable botKeyTable() {
        return this.botKeyTable;
    }

    @Override
    public DAO.ChannelKeyTable channelKeyTable() {
        return this.channelKeyTable;
    }

    @Override
    public DAO.DictionaryKeyTable dictionaryKeyTable() {
        return this.dictionaryKeyTable;
    }

    @Override
    public DAO.DictionaryReplaceTypeKeyTable dictionaryReplaceTypeKeyTable() {
        return this.dictionaryReplaceTypeKeyTable;
    }

    @Override
    public DAO.AutoDisconnectModeKeyTable autoDisconnectModeKeyTable() {
        return this.autoDisconnectModeKeyTable;
    }

    @Override
    public DAO.VoiceTypeKeyTable voiceTypeKeyTable() {
        return this.voiceTypeKeyTable;
    }

    @Override
    public DAO.ServerDataTable serverDataTable() {
        return this.serverDataTable;
    }

    @Override
    public DAO.ServerUserDataTable serverUserDataTable() {
        return this.serverUserDataTable;
    }

    @Override
    public DAO.DictionaryUseDataTable dictionaryUseDataTable() {
        return this.dictionaryUseDataTable;
    }

    @Override
    public DAO.BotStateDataTable botStateDataTable() {
        return this.botStateDataTable;
    }

    @Override
    public DAO.ServerCustomDictionaryTable serverCustomDictionaryTable() {
        return this.serverCustomDictionaryTable;
    }

    @Override
    public DAO.GlobalCustomDictionaryTable globalCustomDictionaryTable() {
        return this.globalCustomDictionaryTable;
    }

    @Override
    public boolean checkEmojiSupport() {
        throw new AssertionError((Object)"TODO");
    }

    private final class ServerKeyTableImpl
    implements DAO.ServerKeyTable {
        private ServerKeyTableImpl() {
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "select id from server_key where discord_id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public Optional<Long> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select discord_id from server_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong("discord_id"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "insert into server_key(discord_id)\nselect ? where not exists(select * from server_key where discord_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                statement.setLong(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists server_key(\n        id integer not null primary key auto_increment, -- ID\n        discord_id bigint not null unique -- Discord\u306eID\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class UserKeyTableImpl
    implements DAO.UserKeyTable {
        private UserKeyTableImpl() {
        }

        @Override
        public Optional<Long> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select discord_id from user_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong("discord_id"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "select id from user_key where discord_id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "insert into user_key(discord_id)\nselect ? where not exists(select * from user_key where discord_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                statement.setLong(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists user_key(\n    id integer not null primary key auto_increment, -- ID\n    discord_id bigint not null unique -- Discord\u306eID\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class BotKeyTableImpl
    implements DAO.BotKeyTable {
        private BotKeyTableImpl() {
        }

        @Override
        public Optional<Long> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select discord_id from bot_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong("discord_id"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "select id from bot_key where discord_id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "insert into bot_key(discord_id)\nselect ? where not exists(select * from bot_key where discord_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                statement.setLong(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists bot_key(\n    id integer not null primary key auto_increment, -- ID\n    discord_id bigint not null unique -- Discord\u306eID\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class ChannelKeyTableImpl
    implements DAO.ChannelKeyTable {
        private ChannelKeyTableImpl() {
        }

        @Override
        public Optional<Long> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select discord_id from channel_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong("discord_id"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "select id from channel_key where discord_id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull Long key) throws SQLException {
            String sql = "insert into channel_key(discord_id)\nselect ? where not exists(select * from channel_key where discord_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key);
                statement.setLong(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists channel_key(\n    id integer not null primary key auto_increment, -- ID\n    discord_id bigint not null unique -- Discord\u306eID\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class DictionaryKeyTableImpl
    implements DAO.DictionaryKeyTable {
        private DictionaryKeyTableImpl() {
        }

        @Override
        public Optional<String> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select name from dictionary_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.of(rs.getString("name"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "select id from dictionary_key where name = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "insert into dictionary_key(name)\nselect ? where not exists(select * from dictionary_key where name = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                statement.setString(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists dictionary_key(\n    id integer not null primary key auto_increment, -- ID\n    name varchar(30) not null unique -- \u53c2\u7167\u540d\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class DictionaryReplaceTypeKeyTableImpl
    implements DAO.DictionaryReplaceTypeKeyTable {
        private DictionaryReplaceTypeKeyTableImpl() {
        }

        @Override
        public Optional<String> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select name from dictionary_replace_type_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.of(rs.getString("name"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "select id from dictionary_replace_type_key where name = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "insert into dictionary_replace_type_key(name)\nselect ? where not exists(select * from dictionary_replace_type_key where name = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                statement.setString(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists dictionary_replace_type_key(\n    id integer not null primary key auto_increment, -- ID\n    name varchar(30) not null unique -- \u53c2\u7167\u540d\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class AutoDisconnectModeKeyTableImpl
    implements DAO.AutoDisconnectModeKeyTable {
        private AutoDisconnectModeKeyTableImpl() {
        }

        @Override
        public Optional<String> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select name from auto_disconnect_mode_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.of(rs.getString("name"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "select id from auto_disconnect_mode_key where name = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "insert into auto_disconnect_mode_key(name)\nselect ? where not exists(select * from auto_disconnect_mode_key where name = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                statement.setString(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists auto_disconnect_mode_key(\n    id integer not null primary key auto_increment, -- ID\n    name varchar(30) not null unique -- \u53c2\u7167\u540d\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class VoiceTypeKeyTableImpl
    implements DAO.VoiceTypeKeyTable {
        private VoiceTypeKeyTableImpl() {
        }

        @Override
        public Optional<String> selectKey(@NotNull Connection connection, int keyId) throws SQLException {
            String sql = "select name from voice_type_key where id = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, keyId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.of(rs.getString("name"));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public OptionalInt selectId(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "select id from voice_type_key where name = ? limit 1;\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        OptionalInt optionalInt = OptionalInt.of(rs.getInt("id"));
                        return optionalInt;
                    }
                }
            }
            return OptionalInt.empty();
        }

        @Override
        public void insertKeyIfNotExists(@NotNull Connection connection, @NotNull String key) throws SQLException {
            String sql = "insert into voice_type_key(name)\nselect ? where not exists(select * from voice_type_key where name = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, key);
                statement.setString(2, key);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists voice_type_key(\n    id integer not null primary key auto_increment, -- ID\n    name varchar(75) not null unique -- \u53c2\u7167\u540d\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class ServerDataTableImpl
    implements DAO.ServerDataTable {
        private ServerDataTableImpl() {
        }

        @Override
        public OptionalInt selectDefaultVoiceType(Connection connection, int recordId) throws SQLException {
            String sql = "select default_voice_type\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Integer val = (Integer)rs.getObject("default_voice_type");
                        OptionalInt optionalInt = val == null ? OptionalInt.empty() : OptionalInt.of(val);
                        return optionalInt;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateDefaultVoiceType(Connection connection, int recordId, @Nullable Integer defaultVoiceTypeKeyId) throws SQLException {
            String sql = "update server_data\nset default_voice_type = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (defaultVoiceTypeKeyId != null) {
                    statement.setInt(1, defaultVoiceTypeKeyId);
                } else {
                    statement.setNull(1, 4);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public Optional<String> selectIgnoreRegex(Connection connection, int recordId) throws SQLException {
            String sql = "select ignore_regex\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.ofNullable(rs.getString("ignore_regex"));
                        return optional;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateIgnoreRegex(Connection connection, int recordId, @Nullable String ignoreRegex) throws SQLException {
            String sql = "update server_data\nset ignore_regex = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, ignoreRegex);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public boolean selectNeedJoin(Connection connection, int recordId) throws SQLException {
            String sql = "select need_join\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getBoolean("need_join");
                        return bl;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateNeedJoin(Connection connection, int recordId, boolean needJoin) throws SQLException {
            String sql = "update server_data\nset need_join = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBoolean(1, needJoin);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public boolean selectOverwriteAloud(Connection connection, int recordId) throws SQLException {
            String sql = "select overwrite_aloud\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getBoolean("overwrite_aloud");
                        return bl;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateOverwriteAloud(Connection connection, int recordId, boolean overwriteAloud) throws SQLException {
            String sql = "update server_data\nset overwrite_aloud = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBoolean(1, overwriteAloud);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public boolean selectNotifyMove(Connection connection, int recordId) throws SQLException {
            String sql = "select notify_move\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getBoolean("notify_move");
                        return bl;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateNotifyMove(Connection connection, int recordId, boolean notifyMove) throws SQLException {
            String sql = "update server_data\nset notify_move = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBoolean(1, notifyMove);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public int selectReadLimit(Connection connection, int recordId) throws SQLException {
            String sql = "select read_limit\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int n = rs.getInt("read_limit");
                        return n;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateReadLimit(Connection connection, int recordId, int readLimit) throws SQLException {
            String sql = "update server_data\nset read_limit = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, readLimit);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public int selectNameReadLimit(Connection connection, int recordId) throws SQLException {
            String sql = "select name_read_limit\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int n = rs.getInt("name_read_limit");
                        return n;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateNameReadLimit(Connection connection, int recordId, int nameReadLimit) throws SQLException {
            String sql = "update server_data\nset name_read_limit = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, nameReadLimit);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public int selectAutoDisconnectMode(Connection connection, int recordId) throws SQLException {
            String sql = "select auto_disconnect_mode\nfrom server_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int n = rs.getInt("auto_disconnect_mode");
                        return n;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateAutoDisconnectMode(Connection connection, int recordId, int autoDisconnectModeKeyId) throws SQLException {
            String sql = "update server_data\nset auto_disconnect_mode = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, autoDisconnectModeKeyId);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public void insertRecordIfNotExists(@NotNull Connection connection, @NotNull ServerKey key, @NotNull ServerDataRecord record) throws SQLException {
            Objects.requireNonNull(record);
            String sql = "insert into server_data(server_id, default_voice_type, ignore_regex, need_join, overwrite_aloud, notify_move,\n           read_limit, name_read_limit, auto_disconnect_mode)\nselect ?, ?, ?, ?, ?, ?, ?, ?, ? where not exists(select * from server_data where server_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, key.serverKeyId());
                if (record.defaultVoiceTypeKeyId() != null) {
                    statement.setInt(2, record.defaultVoiceTypeKeyId());
                } else {
                    statement.setNull(2, 4);
                }
                statement.setString(3, record.ignoreRegex());
                statement.setBoolean(4, record.needJoin());
                statement.setBoolean(5, record.overwriteAloud());
                statement.setBoolean(6, record.notifyMove());
                statement.setInt(7, record.readLimit());
                statement.setInt(8, record.nameReadLimit());
                statement.setInt(9, record.autoDisconnectModeKeyId());
                statement.setInt(10, key.serverKeyId());
                statement.execute();
            }
        }

        @Override
        public Optional<IdRecordPair<ServerDataRecord>> selectRecordByKey(@NotNull Connection connection, @NotNull ServerKey key) throws SQLException {
            String sql = "select id,\n       default_voice_type,\n       ignore_regex,\n       need_join,\n       overwrite_aloud,\n       notify_move,\n       read_limit,\n       name_read_limit,\n       auto_disconnect_mode\n from server_data\n where server_id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<IdRecordPair<ServerDataRecord>> optional = Optional.of(new IdRecordPair<ServerDataRecord>(rs.getInt("id"), this.createRecord(rs)));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<ServerDataRecord> selectRecordById(@NotNull Connection connection, int id) throws SQLException {
            String sql = "select default_voice_type,\n       ignore_regex,\n       need_join,\n       overwrite_aloud,\n       notify_move,\n       read_limit,\n       name_read_limit,\n       auto_disconnect_mode\n from server_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, id);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<ServerDataRecord> optional = Optional.of(this.createRecord(rs));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        private ServerDataRecord createRecord(ResultSet resultSet) throws SQLException {
            return new ServerDataRecord((Integer)resultSet.getObject("default_voice_type"), resultSet.getString("ignore_regex"), resultSet.getBoolean("need_join"), resultSet.getBoolean("overwrite_aloud"), resultSet.getBoolean("notify_move"), resultSet.getInt("read_limit"), resultSet.getInt("name_read_limit"), resultSet.getInt("auto_disconnect_mode"));
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists server_data(\n    id integer not null primary key auto_increment, -- ID\n    server_id integer not null unique, -- \u30b5\u30fc\u30d0\u30fcID\n    default_voice_type integer, -- \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u58f0\u30bf\u30a4\u30d7\n    ignore_regex nvarchar(100), -- \u8aad\u307f\u4e0a\u3052\u3092\u7121\u8996\u3059\u308b\u6b63\u898f\u8868\u73fe\n    need_join boolean not null, -- VC\u306b\u53c2\u52a0\u6642\u306e\u307f\u306b\u8aad\u307f\u4e0a\u3052\u308b\u304b\u3069\u3046\u304b\n    overwrite_aloud boolean not null, -- VC\u306b\u53c2\u52a0\u6642\u306e\u307f\u306b\u8aad\u307f\u4e0a\u3052\u308b\u304b\u3069\u3046\u304b\n    notify_move boolean not null, -- \u8aad\u307f\u4e0a\u3052\u3092\u4e0a\u66f8\u304d\u3059\u308b\u304b\u3069\u3046\u304b\uff56\n    read_limit integer not null, -- VC\u53c2\u52a0\u6642\u306b\u8aad\u307f\u4e0a\u3052\u308b\u304b\u3069\u3046\u304b\n    name_read_limit integer not null, -- \u6700\u5927\u8aad\u307f\u4e0a\u3052\u6587\u5b57\u6570\n    auto_disconnect_mode integer not null, -- \u81ea\u52d5\u5207\u65ad\u306e\u30e2\u30fc\u30c9\n\n    foreign key (server_id) references server_key(id),\n    foreign key (default_voice_type) references voice_type_key(id),\n    foreign key (auto_disconnect_mode) references auto_disconnect_mode_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }
    }

    private final class ServerUserDataTableImpl
    implements DAO.ServerUserDataTable {
        private ServerUserDataTableImpl() {
        }

        @Override
        public OptionalInt selectVoiceType(Connection connection, int recordId) throws SQLException {
            String sql = "select voice_type\nfrom server_user_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Integer val = (Integer)rs.getObject("voice_type");
                        OptionalInt optionalInt = val == null ? OptionalInt.empty() : OptionalInt.of(val);
                        return optionalInt;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateVoiceType(Connection connection, int recordId, @Nullable Integer voiceTypeKeyId) throws SQLException {
            String sql = "update server_user_data\nset voice_type = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (voiceTypeKeyId != null) {
                    statement.setInt(1, voiceTypeKeyId);
                } else {
                    statement.setNull(1, 4);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public boolean selectDeny(Connection connection, int recordId) throws SQLException {
            String sql = "select deny\nfrom server_user_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getBoolean("deny");
                        return bl;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateDeny(Connection connection, int recordId, boolean deny) throws SQLException {
            String sql = "update server_user_data\nset deny = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBoolean(1, deny);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public Optional<String> selectNickName(Connection connection, int recordId) throws SQLException {
            String sql = "select nick_name\nfrom server_user_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<String> optional = Optional.ofNullable(rs.getString("nick_name"));
                        return optional;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateNickName(Connection connection, int recordId, @Nullable String nickName) throws SQLException {
            String sql = "update server_user_data\nset nick_name = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, nickName);
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public void insertRecordIfNotExists(@NotNull Connection connection, @NotNull ServerUserKey key, @NotNull ServerUserDataRecord record) throws SQLException {
            Objects.requireNonNull(record);
            String sql = "insert into server_user_data(server_id, user_id, voice_type, deny, nick_name)\nselect ?, ?, ?, ?, ? where not exists(select * from server_user_data where server_id = ? and user_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, key.serverKeyId());
                statement.setInt(2, key.userKeyId());
                if (record.voiceTypeKeyId() != null) {
                    statement.setInt(3, record.voiceTypeKeyId());
                } else {
                    statement.setNull(3, 4);
                }
                statement.setBoolean(4, record.deny());
                statement.setString(5, record.nickName());
                statement.setInt(6, key.serverKeyId());
                statement.setInt(7, key.userKeyId());
                statement.execute();
            }
        }

        @Override
        public Optional<IdRecordPair<ServerUserDataRecord>> selectRecordByKey(@NotNull Connection connection, @NotNull ServerUserKey key) throws SQLException {
            String sql = "select id,\n       voice_type,\n       deny,\n       nick_name\n from server_user_data\n where server_id = ? and user_id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                statement.setLong(2, key.userKeyId());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<IdRecordPair<ServerUserDataRecord>> optional = Optional.of(new IdRecordPair<ServerUserDataRecord>(rs.getInt("id"), this.createRecord(rs)));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<ServerUserDataRecord> selectRecordById(@NotNull Connection connection, int id) throws SQLException {
            String sql = "select voice_type,\n       deny,\n       nick_name\n from server_user_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, id);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<ServerUserDataRecord> optional = Optional.of(this.createRecord(rs));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        private ServerUserDataRecord createRecord(ResultSet resultSet) throws SQLException {
            return new ServerUserDataRecord((Integer)resultSet.getObject("voice_type"), resultSet.getBoolean("deny"), resultSet.getString("nick_name"));
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists server_user_data(\n    id integer not null primary key auto_increment, -- ID\n    server_id integer not null, -- \u30b5\u30fc\u30d0\u30fcID\n    user_id integer not null, -- \u30e6\u30fc\u30b6\u30fcID\n    voice_type integer, -- \u58f0\u30bf\u30a4\u30d7\n    deny boolean not null, -- \u8aad\u307f\u4e0a\u3052\u62d2\u5426\u3055\u308c\u3066\u3044\u308b\u304b\u3069\u3046\u304b\n    nick_name  nvarchar(100), -- \u30cb\u30c3\u30af\u30cd\u30fc\u30e0\n\n    foreign key (server_id) references server_key(id),\n    foreign key (user_id) references user_key(id),\n    foreign key (voice_type) references voice_type_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }

        @Override
        public List<Long> selectAllDenyUser(Connection connection, int serverKeyId) throws SQLException {
            String sql = "select user_key.discord_id as user_discord_id\nfrom server_user_data\n    inner join user_key on user_id = user_key.id\nwhere server_id = ? and deny = TRUE\n";
            ImmutableList.Builder denyUsersBuilder = ImmutableList.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, serverKeyId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        denyUsersBuilder.add((Object)rs.getLong("user_discord_id"));
                    }
                }
            }
            return denyUsersBuilder.build();
        }
    }

    private final class DictionaryUseDataTableImpl
    implements DAO.DictionaryUseDataTable {
        private DictionaryUseDataTableImpl() {
        }

        @Override
        public Optional<Boolean> selectEnable(Connection connection, int recordId) throws SQLException {
            String sql = "select enable\nfrom dictionary_use_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Object enableRet = rs.getObject("enable");
                        Optional<Boolean> optional = Optional.ofNullable((Boolean)enableRet);
                        return optional;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateEnable(Connection connection, int recordId, @Nullable Boolean enable) throws SQLException {
            String sql = "update dictionary_use_data\nset enable = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (enable != null) {
                    statement.setBoolean(1, enable);
                } else {
                    statement.setNull(1, 16);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public OptionalInt selectPriority(Connection connection, int recordId) throws SQLException {
            String sql = "select priority\nfrom dictionary_use_data\nwhere id = ?\nlimit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Integer val = (Integer)rs.getObject("priority");
                        OptionalInt optionalInt = val == null ? OptionalInt.empty() : OptionalInt.of(val);
                        return optionalInt;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updatePriority(Connection connection, int recordId, Integer priority) throws SQLException {
            String sql = "update dictionary_use_data\nset priority = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (priority != null) {
                    statement.setInt(1, priority);
                } else {
                    statement.setNull(1, 4);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public void insertRecordIfNotExists(@NotNull Connection connection, @NotNull ServerDictionaryKey key, @NotNull DictionaryUseDataRecord record) throws SQLException {
            Objects.requireNonNull(record);
            String sql = "insert into dictionary_use_data(server_id, dictionary_id, enable, priority)\nselect ?, ?, ?, ? where not exists(select * from dictionary_use_data where server_id = ? and dictionary_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, key.serverKeyId());
                statement.setInt(2, key.dictionaryKeyId());
                if (record.enable() != null) {
                    statement.setBoolean(3, record.enable());
                } else {
                    statement.setNull(3, 16);
                }
                if (record.priority() != null) {
                    statement.setInt(4, record.priority());
                } else {
                    statement.setNull(4, 4);
                }
                statement.setInt(5, key.serverKeyId());
                statement.setInt(6, key.dictionaryKeyId());
                statement.execute();
            }
        }

        @Override
        public Optional<IdRecordPair<DictionaryUseDataRecord>> selectRecordByKey(@NotNull Connection connection, @NotNull ServerDictionaryKey key) throws SQLException {
            String sql = "select id,\n       enable,\n       priority\n from dictionary_use_data\n where server_id = ? and dictionary_id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                statement.setLong(2, key.dictionaryKeyId());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<IdRecordPair<DictionaryUseDataRecord>> optional = Optional.of(new IdRecordPair<DictionaryUseDataRecord>(rs.getInt("id"), this.createRecord(rs)));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<DictionaryUseDataRecord> selectRecordById(@NotNull Connection connection, int id) throws SQLException {
            String sql = "select enable,\n       priority\n from dictionary_use_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, id);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<DictionaryUseDataRecord> optional = Optional.of(this.createRecord(rs));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        private DictionaryUseDataRecord createRecord(ResultSet resultSet) throws SQLException {
            return new DictionaryUseDataRecord((Boolean)resultSet.getObject("enable"), (Integer)resultSet.getObject("priority"));
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists dictionary_use_data(\n    id integer not null primary key auto_increment, -- ID\n    server_id integer not null, -- \u30b5\u30fc\u30d0\u30fcID\n    dictionary_id integer not null, -- \u8f9e\u66f8ID\n    enable boolean, -- \u8f9e\u66f8\u3092\u6709\u52b9\u306b\u3057\u3066\u3044\u308b\u304b\u3069\u3046\u304b\n    priority integer, -- \u512a\u5148\u5ea6\n\n    foreign key (server_id) references server_key(id),\n    foreign key (dictionary_id) references dictionary_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }

        @Override
        public List<DictionaryUseEntry> selectAll(Connection connection, int serverKeyId) throws SQLException {
            String sql = "select dictionary_key.name as dictionary_name,\n       enable,\n       priority\nfrom dictionary_use_data\n    inner join dictionary_key on dictionary_id = dictionary_key.id\nwhere server_id = ?\n";
            ArrayList<DictionaryUseEntry> ret = new ArrayList<DictionaryUseEntry>();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, serverKeyId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        ret.add(new DictionaryUseEntry(rs.getString("dictionary_name"), (Boolean)rs.getObject("enable"), (Integer)rs.getObject("priority")));
                    }
                }
            }
            return ret;
        }
    }

    private final class BotStateDataTableImpl
    implements DAO.BotStateDataTable {
        private BotStateDataTableImpl() {
        }

        @Override
        public Optional<TTSChannelKeyPair> selectConnectedChannelKeyPair(Connection connection, int recordId) throws SQLException {
            block16: {
                String sql = "select speak_audio_channel,\n       read_text_channel\nfrom bot_state_data\nwhere id = ?\nlimit 1\n";
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    statement.setLong(1, recordId);
                    ResultSet rs = statement.executeQuery();
                    if (!rs.next()) break block16;
                    Integer audioChannel = (Integer)rs.getObject("speak_audio_channel");
                    Integer textChannel = (Integer)rs.getObject("read_text_channel");
                    if (audioChannel == null || textChannel == null) {
                        Optional<TTSChannelKeyPair> optional = Optional.empty();
                        return optional;
                    }
                    Optional<TTSChannelKeyPair> optional = Optional.of(new TTSChannelKeyPair(audioChannel, textChannel));
                    return optional;
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateConnectedChannelKeyPair(Connection connection, int recordId, @Nullable TTSChannelKeyPair channelKeyPair) throws SQLException {
            String sql = "update bot_state_data\nset speak_audio_channel = ?, read_text_channel = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (channelKeyPair != null) {
                    statement.setLong(1, channelKeyPair.speakAudioChannelKey());
                    statement.setLong(2, channelKeyPair.readTextChannelKey());
                } else {
                    statement.setNull(1, 4);
                    statement.setNull(2, 4);
                }
                statement.setLong(3, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public Optional<TTSChannelKeyPair> selectReconnectChannelKeyPair(Connection connection, int recordId) throws SQLException {
            block16: {
                String sql = "select reconnect_speak_audio_channel,\n       reconnect_read_text_channel\nfrom bot_state_data\nwhere id = ?\nlimit 1\n";
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    statement.setLong(1, recordId);
                    ResultSet rs = statement.executeQuery();
                    if (!rs.next()) break block16;
                    Integer audioChannel = (Integer)rs.getObject("reconnect_speak_audio_channel");
                    Integer textChannel = (Integer)rs.getObject("reconnect_read_text_channel");
                    if (audioChannel == null || textChannel == null) {
                        Optional<TTSChannelKeyPair> optional = Optional.empty();
                        return optional;
                    }
                    Optional<TTSChannelKeyPair> optional = Optional.of(new TTSChannelKeyPair(audioChannel, textChannel));
                    return optional;
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateReconnectChannelKeyPair(Connection connection, int recordId, @Nullable TTSChannelKeyPair channelKeyPair) throws SQLException {
            String sql = "update bot_state_data\nset reconnect_speak_audio_channel = ?, reconnect_read_text_channel = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (channelKeyPair != null) {
                    statement.setLong(1, channelKeyPair.speakAudioChannelKey());
                    statement.setLong(2, channelKeyPair.readTextChannelKey());
                } else {
                    statement.setNull(1, 4);
                    statement.setNull(2, 4);
                }
                statement.setLong(3, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public void insertRecordIfNotExists(@NotNull Connection connection, @NotNull ServerBotKey key, @NotNull BotStateDataRecord record) throws SQLException {
            Objects.requireNonNull(record);
            String sql = "insert into bot_state_data(server_id, bot_id, speak_audio_channel, read_text_channel, reconnect_speak_audio_channel, reconnect_read_text_channel)\nselect ?, ?, ?, ?, ?, ? where not exists(select * from bot_state_data where server_id = ? and bot_id = ?);\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, key.serverKeyId());
                statement.setInt(2, key.botKeyId());
                if (record.speakAudioChannelKey() != null) {
                    statement.setInt(3, record.speakAudioChannelKey());
                } else {
                    statement.setNull(3, 4);
                }
                if (record.readTextChannelKey() != null) {
                    statement.setInt(4, record.readTextChannelKey());
                } else {
                    statement.setNull(4, 4);
                }
                if (record.reconnectSpeakAudioChannelKey() != null) {
                    statement.setInt(5, record.reconnectSpeakAudioChannelKey());
                } else {
                    statement.setNull(5, 4);
                }
                if (record.reconnectReadTextChannelKey() != null) {
                    statement.setInt(6, record.reconnectReadTextChannelKey());
                } else {
                    statement.setNull(6, 4);
                }
                statement.setInt(7, key.serverKeyId());
                statement.setInt(8, key.botKeyId());
                statement.execute();
            }
        }

        @Override
        public Optional<IdRecordPair<BotStateDataRecord>> selectRecordByKey(@NotNull Connection connection, @NotNull ServerBotKey key) throws SQLException {
            String sql = "select id,\n       speak_audio_channel,\n       read_text_channel,\n       reconnect_speak_audio_channel,\n       reconnect_read_text_channel\n from bot_state_data\n where server_id = ? and bot_id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                statement.setLong(2, key.botKeyId());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<IdRecordPair<BotStateDataRecord>> optional = Optional.of(new IdRecordPair<BotStateDataRecord>(rs.getInt("id"), this.createRecord(rs)));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<BotStateDataRecord> selectRecordById(@NotNull Connection connection, int id) throws SQLException {
            String sql = "select speak_audio_channel,\n       read_text_channel,\n       reconnect_speak_audio_channel,\n       reconnect_read_text_channel\n from bot_state_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, id);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Optional<BotStateDataRecord> optional = Optional.of(this.createRecord(rs));
                        return optional;
                    }
                }
            }
            return Optional.empty();
        }

        private BotStateDataRecord createRecord(ResultSet resultSet) throws SQLException {
            return new BotStateDataRecord((Integer)resultSet.getObject("speak_audio_channel"), (Integer)resultSet.getObject("read_text_channel"), (Integer)resultSet.getObject("reconnect_speak_audio_channel"), (Integer)resultSet.getObject("reconnect_read_text_channel"));
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists bot_state_data(\n    id integer not null primary key auto_increment, -- ID\n    server_id integer not null, -- \u30b5\u30fc\u30d0\u30fcID\n    bot_id integer not null, -- BOT ID\n    speak_audio_channel integer, -- \u63a5\u7d9a\u30aa\u30fc\u30c7\u30a3\u30aa\u30c1\u30e3\u30f3\u30cd\u30eb\n    read_text_channel integer, -- \u8aad\u307f\u4e0a\u3052\u308b\u30c6\u30ad\u30b9\u30c8\u30c1\u30e3\u30f3\u30cd\u30eb\n    reconnect_speak_audio_channel integer, -- \u518d\u63a5\u7d9a\u5148\u30aa\u30fc\u30c7\u30a3\u30aa\u30c1\u30e3\u30f3\u30cd\u30eb\n    reconnect_read_text_channel integer, -- \u518d\u63a5\u7d9a\u5148\u8aad\u307f\u4e0a\u3052\u30c1\u30e3\u30f3\u30cd\u30eb\n\n    foreign key (server_id) references server_key(id),\n    foreign key (bot_id) references bot_key(id),\n    foreign key (speak_audio_channel) references channel_key(id),\n    foreign key (read_text_channel) references channel_key(id),\n    foreign key (reconnect_speak_audio_channel) references channel_key(id),\n    foreign key (reconnect_read_text_channel) references channel_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }

        @Override
        public Map<Long, TTSChannelPair> selectAllConnectedChannelPairByBotKeyId(Connection connection, int botKeyId) throws SQLException {
            String sql = "select server_key.discord_id as server_discord_id,\n       speak_audio_channel_key.discord_id as speak_audio_channel_discord_id,\n       read_text_channel_key.discord_id as read_text_channel_discord_id\n from bot_state_data\n    inner join server_key on server_id = server_key.id\n    inner join channel_key as speak_audio_channel_key on speak_audio_channel = speak_audio_channel_key.id\n    inner join channel_key as read_text_channel_key on read_text_channel = read_text_channel_key.id\n where bot_id = ? and speak_audio_channel is not null and read_text_channel is not null\n";
            ImmutableMap.Builder retBuilder = ImmutableMap.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, botKeyId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        if (rs.getObject("speak_audio_channel_discord_id") == null || rs.getObject("read_text_channel_discord_id") == null) continue;
                        long speakAudioChannel = rs.getLong("speak_audio_channel_discord_id");
                        long readTextChannel = rs.getLong("read_text_channel_discord_id");
                        TTSChannelPair channelPair = new TTSChannelPair(speakAudioChannel, readTextChannel);
                        retBuilder.put((Object)rs.getLong("server_discord_id"), (Object)channelPair);
                    }
                }
            }
            return retBuilder.build();
        }

        @Override
        public OptionalInt selectSpeakAudioChannel(Connection connection, int recordId) throws SQLException {
            String sql = "select speak_audio_channel\n from bot_state_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Integer channelKey = (Integer)rs.getObject("speak_audio_channel");
                        OptionalInt optionalInt = channelKey != null ? OptionalInt.of(channelKey) : OptionalInt.empty();
                        return optionalInt;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateSpeakAudioChannel(Connection connection, int recordId, Integer channelKeyId) throws SQLException {
            String sql = "update bot_state_data\nset speak_audio_channel = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (channelKeyId != null) {
                    statement.setLong(1, channelKeyId.intValue());
                } else {
                    statement.setNull(1, 4);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        @Override
        public OptionalInt selectReadAroundTextChannel(Connection connection, int recordId) throws SQLException {
            String sql = "select read_text_channel\n from bot_state_data\n where id = ?\n limit 1\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, recordId);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        Integer channelKey = (Integer)rs.getObject("read_text_channel");
                        OptionalInt optionalInt = channelKey != null ? OptionalInt.of(channelKey) : OptionalInt.empty();
                        return optionalInt;
                    }
                }
            }
            throw new IllegalStateException("Record not found");
        }

        @Override
        public void updateReadAroundTextChannel(Connection connection, int recordId, Integer channelKeyId) throws SQLException {
            String sql = "update bot_state_data\nset read_text_channel = ?\nwhere id = ?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (channelKeyId != null) {
                    statement.setLong(1, channelKeyId.intValue());
                } else {
                    statement.setNull(1, 4);
                }
                statement.setLong(2, recordId);
                if (statement.executeUpdate() == 0) {
                    throw new IllegalStateException("No record update");
                }
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public List<Long> selectAll(Connection connection, int botKeyId) throws SQLException {
            String sql = "select server_key.discord_id as server_discord_id\n from bot_state_data\n    inner join server_key on server_id = server_key.id\n where bot_id = ?\n";
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ImmutableList.Builder retBuilder = ImmutableList.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, botKeyId);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        if (rs.getObject("server_discord_id") == null) continue;
                        retBuilder.add((Object)rs.getLong("server_discord_id"));
                    }
                }
            }
            return retBuilder.build();
        }
    }

    private final class ServerCustomDictionaryTableImpl
    implements DAO.ServerCustomDictionaryTable {
        private ServerCustomDictionaryTableImpl() {
        }

        @Override
        public Map<Integer, DictionaryRecord> selectRecords(Connection connection, @NotNull ServerKey key) throws SQLException {
            String sql = "select id,\n       target_word,\n       read_word,\n       replace_type\nfrom server_custom_dictionary\nwhere server_id = ?\n";
            ImmutableMap.Builder ret = ImmutableMap.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        DictionaryRecord record = new DictionaryRecord(rs.getString("target_word"), rs.getString("read_word"), rs.getInt("replace_type"));
                        ret.put((Object)rs.getInt("id"), (Object)record);
                    }
                }
            }
            return ret.build();
        }

        @Override
        public void insertRecord(Connection connection, @NotNull ServerKey key, @NotNull DictionaryRecord record) throws SQLException {
            String sql = "insert into server_custom_dictionary(server_id, target_word, read_word, replace_type)\nvalues(?, ?, ?, ?)\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, key.serverKeyId());
                statement.setString(2, record.target());
                statement.setString(3, record.read());
                statement.setInt(4, record.replaceTypeKeyId());
                statement.execute();
            }
        }

        @Override
        public void deleteRecord(Connection connection, int recordId) throws SQLException {
            String sql = "delete from server_custom_dictionary where id=?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, recordId);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists server_custom_dictionary(\n    id integer not null primary key auto_increment, -- ID\n    server_id integer not null, -- \u30b5\u30fc\u30d0\u30fcID\n    target_word nvarchar(1000) not null, -- \u7f6e\u304d\u63db\u3048\u5bfe\u8c61\u306e\u6587\u5b57\n    read_word nvarchar(1000) not null, -- \u5b9f\u969b\u306b\u8aad\u307f\u4e0a\u3052\u308b\u6587\u5b57\n    replace_type integer not null, -- \u7f6e\u304d\u63db\u3048\u65b9\u6cd5\n\n    foreign key (server_id) references server_key(id),\n    foreign key (replace_type) references dictionary_replace_type_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }

        @Override
        public Map<Integer, DictionaryRecord> selectRecordByTarget(Connection connection, @NotNull ServerKey key, @NotNull String targetWord) throws SQLException {
            String sql = "select id,\n       target_word,\n       read_word,\n       replace_type\nfrom server_custom_dictionary\nwhere server_id = ? and target_word = ?\n";
            ImmutableMap.Builder ret = ImmutableMap.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, key.serverKeyId());
                statement.setString(2, targetWord);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        DictionaryRecord record = new DictionaryRecord(rs.getString("target_word"), rs.getString("read_word"), rs.getInt("replace_type"));
                        ret.put((Object)rs.getInt("id"), (Object)record);
                    }
                }
            }
            return ret.build();
        }
    }

    private final class GlobalCustomDictionaryTableImpl
    implements DAO.GlobalCustomDictionaryTable {
        private GlobalCustomDictionaryTableImpl() {
        }

        @Override
        public @Unmodifiable Map<Integer, DictionaryRecord> selectRecords(Connection connection) throws SQLException {
            String sql = "select id,\n       target_word,\n       read_word,\n       replace_type\nfrom global_custom_dictionary\n";
            ImmutableMap.Builder ret = ImmutableMap.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    DictionaryRecord record = new DictionaryRecord(rs.getString("target_word"), rs.getString("read_word"), rs.getInt("replace_type"));
                    ret.put((Object)rs.getInt("id"), (Object)record);
                }
            }
            return ret.build();
        }

        @Override
        public void insertRecord(Connection connection, @NotNull DictionaryRecord record) throws SQLException {
            String sql = "insert into global_custom_dictionary(target_word, read_word, replace_type)\nvalues(?, ?, ?)\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, record.target());
                statement.setString(2, record.read());
                statement.setInt(3, record.replaceTypeKeyId());
                statement.execute();
            }
        }

        @Override
        public void deleteRecord(Connection connection, int recordId) throws SQLException {
            String sql = "delete from global_custom_dictionary where id=?\n";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, recordId);
                statement.execute();
            }
        }

        @Override
        public void createTableIfNotExists(@NotNull Connection connection) throws SQLException {
            String sql = "create table if not exists global_custom_dictionary(\n    id integer not null primary key auto_increment, -- ID\n    target_word nvarchar(1000) not null, -- \u7f6e\u304d\u63db\u3048\u5bfe\u8c61\u306e\u6587\u5b57\n    read_word nvarchar(1000) not null, -- \u5b9f\u969b\u306b\u8aad\u307f\u4e0a\u3052\u308b\u6587\u5b57\n    replace_type integer not null, -- \u7f6e\u304d\u63db\u3048\u65b9\u6cd5\n\n    foreign key (replace_type) references dictionary_replace_type_key(id)\n);\n";
            MySQLDAO.this.execute(connection, sql);
        }

        @Override
        public Map<Integer, DictionaryRecord> selectRecordByTarget(Connection connection, @NotNull String targetWord) throws SQLException {
            String sql = "select id,\n       target_word,\n       read_word,\n       replace_type\nfrom global_custom_dictionary\nwhere target_word = ?\n";
            ImmutableMap.Builder ret = ImmutableMap.builder();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, targetWord);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        DictionaryRecord record = new DictionaryRecord(rs.getString("target_word"), rs.getString("read_word"), rs.getInt("replace_type"));
                        ret.put((Object)rs.getInt("id"), (Object)record);
                    }
                }
            }
            return ret.build();
        }
    }
}

