/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.legacy;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.itts.core.dict.CustomDictionaryEntry;
import dev.felnull.itts.core.dict.ReplaceType;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.CustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.savedata.repository.DictionaryUseData;
import dev.felnull.itts.core.savedata.repository.ServerData;
import dev.felnull.itts.core.savedata.repository.ServerUserData;
import dev.felnull.itts.core.util.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegacyMigrator {
    private static final Logger LOGGER = LogManager.getLogger(LegacyMigrator.class);
    private static final File JSON_SAVE_DIR = new File("./save_data");
    private static final File GLOBAL_DICT_DIR = new File("./global_dict.json");
    private final Gson gson = new Gson();

    private LegacyMigrator() {
    }

    private void execute(DataRepository repo) {
        this.migrateServerData(repo);
        this.migrateServerUserData(repo);
        this.migrateServerDictUseData(repo);
        this.migrateServerDictData(repo);
        this.migrateGlobalDictData(repo);
    }

    private void migrateServerData(DataRepository repo) {
        File dir = new File(JSON_SAVE_DIR, "server");
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).forEach(file -> {
            long serverId;
            String name = FNStringUtil.removeExtension((String)file.getName());
            try {
                serverId = Long.parseLong(name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid file name {}", (Object)file.getName());
                return;
            }
            JsonObject jo = this.loadJson((File)file);
            if (jo == null) {
                return;
            }
            String defaultVoiceType = JsonUtils.getString(jo, "default_voice_type", null);
            String ignoreRegex = JsonUtils.getString(jo, "ignore_regex", "(!|/|\\\\$|`).*");
            boolean needJoin = JsonUtils.getBoolean(jo, "need_join", false);
            boolean overwriteAloud = JsonUtils.getBoolean(jo, "overwrite_aloud", false);
            boolean notifyMove = JsonUtils.getBoolean(jo, "notify_move", true);
            int readLimit = JsonUtils.getInt(jo, "read_limit", 200);
            int nameReadLimit = JsonUtils.getInt(jo, "name_read_limit", 20);
            ServerData serverData = repo.getServerData(serverId);
            serverData.setDefaultVoiceType(defaultVoiceType);
            serverData.setIgnoreRegex(ignoreRegex);
            serverData.setNeedJoin(needJoin);
            serverData.setOverwriteAloud(overwriteAloud);
            serverData.setNotifyMove(notifyMove);
            serverData.setReadLimit(readLimit);
            serverData.setNameReadLimit(nameReadLimit);
        });
    }

    private void migrateServerUserData(DataRepository repo) {
        File dir = new File(JSON_SAVE_DIR, "server_users");
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).forEach(file -> {
            long serverId;
            String name = FNStringUtil.removeExtension((String)file.getName());
            try {
                serverId = Long.parseLong(name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid file name {}", (Object)file.getName());
                return;
            }
            JsonObject jo = this.loadJson((File)file);
            if (jo == null) {
                return;
            }
            JsonObject dataJo = jo.getAsJsonObject("data");
            if (dataJo == null) {
                return;
            }
            dataJo.entrySet().stream().filter(it -> ((JsonElement)it.getValue()).isJsonObject()).forEach(entry -> {
                long userId;
                try {
                    userId = Long.parseLong(name);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid data name {}", (Object)file.getName());
                    return;
                }
                JsonObject entryJo = ((JsonElement)entry.getValue()).getAsJsonObject();
                String voiceType = JsonUtils.getString(entryJo, "voice_type", null);
                boolean deny = JsonUtils.getBoolean(entryJo, "deny", false);
                String nickName = JsonUtils.getString(entryJo, "nick_name", null);
                ServerUserData serverUserData = repo.getServerUserData(serverId, userId);
                serverUserData.setVoiceType(voiceType);
                serverUserData.setDeny(deny);
                serverUserData.setNickName(nickName);
            });
        });
    }

    private void migrateServerDictUseData(DataRepository repo) {
        File dir = new File(JSON_SAVE_DIR, "dict_use");
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).forEach(file -> {
            long serverId;
            String name = FNStringUtil.removeExtension((String)file.getName());
            try {
                serverId = Long.parseLong(name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid file name {}", (Object)file.getName());
                return;
            }
            JsonObject jo = this.loadJson((File)file);
            if (jo == null) {
                return;
            }
            JsonObject dataJo = jo.getAsJsonObject("data");
            if (dataJo == null) {
                return;
            }
            dataJo.entrySet().stream().filter(it -> ((JsonElement)it.getValue()).isJsonPrimitive()).filter(it -> ((JsonElement)it.getValue()).getAsJsonPrimitive().isNumber()).forEach(entry -> {
                String dictName = (String)entry.getKey();
                int priority = ((JsonElement)entry.getValue()).getAsInt();
                DictionaryUseData dictionaryUseData = repo.getDictionaryUseData(serverId, dictName);
                if (priority >= 0) {
                    dictionaryUseData.setEnable(true);
                    dictionaryUseData.setPriority(priority);
                } else {
                    dictionaryUseData.setEnable(false);
                    dictionaryUseData.setPriority(null);
                }
            });
        });
    }

    private void migrateServerDictData(DataRepository repo) {
        File dir = new File(JSON_SAVE_DIR, "server_dict");
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).forEach(file -> {
            long serverId;
            String name = FNStringUtil.removeExtension((String)file.getName());
            try {
                serverId = Long.parseLong(name);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid file name {}", (Object)file.getName());
                return;
            }
            JsonObject jo = this.loadJson((File)file);
            if (jo == null) {
                return;
            }
            Map<String, String> dictEntry = this.loadDict(jo);
            CustomDictionaryData dictionaryData = repo.getServerCustomDictionaryData(serverId);
            dictEntry.forEach((target, read) -> dictionaryData.add(new CustomDictionaryEntry((String)target, (String)read, ReplaceType.WORD)));
        });
    }

    private void migrateGlobalDictData(DataRepository repo) {
        if (!GLOBAL_DICT_DIR.exists()) {
            return;
        }
        JsonObject jo = this.loadJson(GLOBAL_DICT_DIR);
        if (jo == null) {
            return;
        }
        Map<String, String> dictEntry = this.loadDict(jo);
        CustomDictionaryData dictionaryData = repo.getGlobalCustomDictionaryData();
        dictEntry.forEach((target, read) -> dictionaryData.add(new CustomDictionaryEntry((String)target, (String)read, ReplaceType.WORD)));
    }

    private Map<String, String> loadDict(JsonObject jo) {
        HashMap<String, String> entry = new HashMap<String, String>();
        JsonObject dataJo = jo.getAsJsonObject("data");
        if (dataJo != null) {
            dataJo.entrySet().stream().filter(it -> ((JsonElement)it.getValue()).isJsonPrimitive()).filter(it -> ((JsonElement)it.getValue()).getAsJsonPrimitive().isString()).forEach(it -> entry.put((String)it.getKey(), ((JsonElement)it.getValue()).getAsString()));
        }
        return entry;
    }

    private JsonObject loadJson(File file) {
        JsonObject jo;
        try (FileReader reader = new FileReader(file);
             BufferedReader bufReader = new BufferedReader(reader);){
            jo = (JsonObject)this.gson.fromJson((Reader)bufReader, JsonObject.class);
        }
        catch (IOException e) {
            LOGGER.error("Loading failed {}", (Object)file.getName(), (Object)e);
            return null;
        }
        int version = JsonUtils.getInt(jo, "version", -1);
        if (version != 0) {
            LOGGER.error("Unsupported config version {}", (Object)file.getName());
            return null;
        }
        return jo;
    }

    public static void checkAndExecution(Supplier<DAO> daoProvider) {
        if (!JSON_SAVE_DIR.exists() && !GLOBAL_DICT_DIR.exists()) {
            return;
        }
        LOGGER.info("Started migration from JSON format to DB format");
        DataRepository repo = DataRepository.create(daoProvider.get());
        repo.init();
        repo.addErrorListener(error -> LOGGER.error("DataBase Error", error));
        LegacyMigrator migrator = new LegacyMigrator();
        migrator.execute(repo);
        repo.dispose();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
        String timeText = LocalDateTime.now().format(timeFormatter);
        File moveDir = new File("old_save_data-" + timeText);
        try {
            if (JSON_SAVE_DIR.exists()) {
                Files.move((File)JSON_SAVE_DIR, (File)moveDir);
            }
            if (GLOBAL_DICT_DIR.exists()) {
                FNDataUtil.wishMkdir((File)moveDir);
                Files.move((File)GLOBAL_DICT_DIR, (File)new File(moveDir, "global_dict.json"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to move Old SaveData", e);
        }
        LOGGER.info("Migration done");
    }
}

