/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.legacy.impl;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.dict.CustomDictionaryEntry;
import dev.felnull.itts.core.dict.ReplaceType;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacyDictData;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerData;
import dev.felnull.itts.core.savedata.legacy.LegacyServerUserData;
import dev.felnull.itts.core.savedata.legacy.impl.LegacyDictDataImpl;
import dev.felnull.itts.core.savedata.legacy.impl.LegacyServerDataImpl;
import dev.felnull.itts.core.savedata.legacy.impl.LegacyServerUserDataImpl;
import dev.felnull.itts.core.savedata.repository.IdCustomDictionaryEntryPair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LegacySaveDataLayerImpl
implements LegacySaveDataLayer {
    private final SaveDataManager saveDataManager;

    public LegacySaveDataLayerImpl(SaveDataManager saveDataManager) {
        this.saveDataManager = saveDataManager;
    }

    @Override
    @NotNull
    public LegacyServerData getServerData(long guildId) {
        return new LegacyServerDataImpl(this.saveDataManager, guildId);
    }

    @Override
    @NotNull
    public LegacyServerUserData getServerUserData(long guildId, long userId) {
        return new LegacyServerUserDataImpl(this.saveDataManager, guildId, userId);
    }

    @Override
    @NotNull
    public @Unmodifiable List<LegacyDictData> getAllServerDictData(long guildId) {
        List<LegacyDictData> allDictData = this.saveDataManager.getRepository().getServerCustomDictionaryData(guildId).getAll().stream().map(IdCustomDictionaryEntryPair::entry).map(it -> new LegacyDictDataImpl(it.target(), it.read())).toList();
        return ImmutableList.copyOf(allDictData);
    }

    @Override
    @Nullable
    public LegacyDictData getServerDictData(long guildId, @NotNull String target) {
        IdCustomDictionaryEntryPair ret = this.saveDataManager.getRepository().getServerCustomDictionaryData(guildId).getByTarget(target).stream().findFirst().orElse(null);
        if (ret != null) {
            return new LegacyDictDataImpl(ret.entry().target(), ret.entry().read());
        }
        return null;
    }

    @Override
    public void addServerDictData(long guildId, @NotNull String target, @NotNull String read) {
        this.saveDataManager.getRepository().getServerCustomDictionaryData(guildId).add(new CustomDictionaryEntry(target, read, ReplaceType.WORD));
    }

    @Override
    public void removeServerDictData(long guildId, @NotNull String target) {
        @NotNull @Unmodifiable List<IdCustomDictionaryEntryPair> ret = this.saveDataManager.getRepository().getServerCustomDictionaryData(guildId).getByTarget(target);
        ret.forEach(it -> this.saveDataManager.getRepository().getServerCustomDictionaryData(guildId).remove(it.id()));
    }

    @Override
    @NotNull
    public @Unmodifiable List<LegacyDictData> getAllGlobalDictData() {
        List<LegacyDictData> allDictData = this.saveDataManager.getRepository().getGlobalCustomDictionaryData().getAll().stream().map(IdCustomDictionaryEntryPair::entry).map(it -> new LegacyDictDataImpl(it.target(), it.read())).toList();
        return ImmutableList.copyOf(allDictData);
    }

    @Override
    @NotNull
    public @Unmodifiable List<Long> getAllDenyUser(long guildId) {
        return this.saveDataManager.getRepository().getAllDenyUser(guildId);
    }
}

