/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository;

import dev.felnull.itts.core.dict.DictionaryUseEntry;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.CustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.DictionaryUseData;
import dev.felnull.itts.core.savedata.repository.RepoErrorListener;
import dev.felnull.itts.core.savedata.repository.ServerData;
import dev.felnull.itts.core.savedata.repository.ServerUserData;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface DataRepository {
    public static DataRepository create(DAO dao) {
        return new DataRepositoryImpl(dao);
    }

    public void init();

    public void dispose();

    public void addErrorListener(RepoErrorListener var1);

    public void removeErrorListener(RepoErrorListener var1);

    @NotNull
    public ServerData getServerData(long var1);

    @NotNull
    public ServerUserData getServerUserData(long var1, long var3);

    @NotNull
    public DictionaryUseData getDictionaryUseData(long var1, String var3);

    @NotNull
    public BotStateData getBotStateData(long var1, long var3);

    @NotNull
    public CustomDictionaryData getServerCustomDictionaryData(long var1);

    @NotNull
    public CustomDictionaryData getGlobalCustomDictionaryData();

    @NotNull
    public @Unmodifiable Map<Long, TTSChannelPair> getAllConnectedChannel(long var1);

    @NotNull
    public @Unmodifiable List<Long> getAllDenyUser(long var1);

    @NotNull
    public @Unmodifiable List<DictionaryUseEntry> getAllDictionaryUseData(long var1);

    @NotNull
    public @Unmodifiable Map<Long, BotStateData> getAllBotStateData(long var1);
}

