/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.savedata.dao.BotStateDataRecord;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.ServerBotKey;
import dev.felnull.itts.core.savedata.dao.TTSChannelKeyPair;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.RecordData;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.Nullable;

class BotStateDataImpl
extends RecordData<ServerBotKey, BotStateDataRecord>
implements BotStateData {
    private final long serverId;
    private final long botId;

    BotStateDataImpl(DataRepositoryImpl repository, long serverId, long botId) {
        super(repository);
        this.serverId = serverId;
        this.botId = botId;
    }

    @Override
    protected RecordData.InitRecordContext getInitRecordContext() {
        int serverKeyId = this.repository.getServerKeyData().getId(this.serverId);
        int botKeyId = this.repository.getBotKeyData().getId(this.botId);
        ServerBotKey serverBotKey = new ServerBotKey(serverKeyId, botKeyId);
        return new RecordData.InitRecordContext((RecordData)this, (DAO.DataTable)this.dao().botStateDataTable(), (Record)serverBotKey, () -> new BotStateDataRecord(null, null, null, null));
    }

    @Override
    @Nullable
    public TTSChannelPair getConnectedChannelPair() {
        return (TTSChannelPair)this.sqlProcReturnable(connection -> {
            Optional<TTSChannelKeyPair> connectedChannel = this.dao().botStateDataTable().selectConnectedChannelKeyPair((Connection)connection, this.recordId());
            if (connectedChannel.isEmpty()) {
                return null;
            }
            Long speakAudioChannel = this.repository.getChannelKeyData().getKey(connectedChannel.get().speakAudioChannelKey());
            Long readTextChannel = this.repository.getChannelKeyData().getKey(connectedChannel.get().readTextChannelKey());
            if (speakAudioChannel != null && readTextChannel != null) {
                return new TTSChannelPair(speakAudioChannel, readTextChannel);
            }
            return null;
        });
    }

    @Override
    public void setConnectedChannelPair(@Nullable TTSChannelPair connectedChannel) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            TTSChannelKeyPair ttsChannelKeyPair;
            if (connectedChannel != null) {
                int speakAudioChannelKey = this.repository.getChannelKeyData().getId(connectedChannel.speakAudioChannel());
                int readTextChannelKey = this.repository.getChannelKeyData().getId(connectedChannel.readTextChannel());
                ttsChannelKeyPair = new TTSChannelKeyPair(speakAudioChannelKey, readTextChannelKey);
            } else {
                ttsChannelKeyPair = null;
            }
            this.dao().botStateDataTable().updateConnectedChannelKeyPair((Connection)connection, this.recordId(), ttsChannelKeyPair);
        }));
    }

    @Override
    @Nullable
    public TTSChannelPair getReconnectChannelPair() {
        return (TTSChannelPair)this.sqlProcReturnable(connection -> {
            Optional<TTSChannelKeyPair> reconnectChannel = this.dao().botStateDataTable().selectReconnectChannelKeyPair((Connection)connection, this.recordId());
            if (reconnectChannel.isEmpty()) {
                return null;
            }
            Long speakAudioChannel = this.repository.getChannelKeyData().getKey(reconnectChannel.get().speakAudioChannelKey());
            Long readTextChannel = this.repository.getChannelKeyData().getKey(reconnectChannel.get().readTextChannelKey());
            if (speakAudioChannel != null && readTextChannel != null) {
                return new TTSChannelPair(speakAudioChannel, readTextChannel);
            }
            return null;
        });
    }

    @Override
    public void setReconnectChannelPair(@Nullable TTSChannelPair reconnectChannel) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            TTSChannelKeyPair ttsChannelKeyPair;
            if (reconnectChannel != null) {
                int speakAudioChannelKey = this.repository.getChannelKeyData().getId(reconnectChannel.speakAudioChannel());
                int readTextChannelKey = this.repository.getChannelKeyData().getId(reconnectChannel.readTextChannel());
                ttsChannelKeyPair = new TTSChannelKeyPair(speakAudioChannelKey, readTextChannelKey);
            } else {
                ttsChannelKeyPair = null;
            }
            this.dao().botStateDataTable().updateReconnectChannelKeyPair((Connection)connection, this.recordId(), ttsChannelKeyPair);
        }));
    }

    @Override
    @Nullable
    public Long getSpeakAudioChannel() {
        return (Long)this.sqlProcReturnable(connection -> {
            OptionalInt channelKeyId = this.dao().botStateDataTable().selectSpeakAudioChannel((Connection)connection, this.recordId());
            if (channelKeyId.isPresent()) {
                return this.repository.getChannelKeyData().getKey(channelKeyId.getAsInt());
            }
            return null;
        });
    }

    @Override
    public void setSpeakAudioChannel(@Nullable Long channelId) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            OptionalInt channelKey = this.repository.getChannelKeyData().getIdNullable(channelId);
            this.dao().botStateDataTable().updateSpeakAudioChannel((Connection)connection, this.recordId(), channelKey.isPresent() ? Integer.valueOf(channelKey.getAsInt()) : null);
        }));
    }

    @Override
    @Nullable
    public Long getReadAroundTextChannel() {
        return (Long)this.sqlProcReturnable(connection -> {
            OptionalInt channelKeyId = this.dao().botStateDataTable().selectReadAroundTextChannel((Connection)connection, this.recordId());
            if (channelKeyId.isPresent()) {
                return this.repository.getChannelKeyData().getKey(channelKeyId.getAsInt());
            }
            return null;
        });
    }

    @Override
    public void setReadAroundTextChannel(@Nullable Long channelId) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            OptionalInt channelKey = this.repository.getChannelKeyData().getIdNullable(channelId);
            this.dao().botStateDataTable().updateReadAroundTextChannel((Connection)connection, this.recordId(), channelKey.isPresent() ? Integer.valueOf(channelKey.getAsInt()) : null);
        }));
    }
}

