/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.felnull.itts.core.dict.DictionaryUseEntry;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.CustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.savedata.repository.DictionaryUseData;
import dev.felnull.itts.core.savedata.repository.RepoErrorListener;
import dev.felnull.itts.core.savedata.repository.ServerData;
import dev.felnull.itts.core.savedata.repository.ServerUserData;
import dev.felnull.itts.core.savedata.repository.impl.BotStateDataImpl;
import dev.felnull.itts.core.savedata.repository.impl.DictionaryUseDataImpl;
import dev.felnull.itts.core.savedata.repository.impl.GlobalCustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.impl.KeyData;
import dev.felnull.itts.core.savedata.repository.impl.ServerCustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.impl.ServerDataImpl;
import dev.felnull.itts.core.savedata.repository.impl.ServerUserDataImpl;
import dev.felnull.itts.core.tts.TTSChannelPair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class DataRepositoryImpl
implements DataRepository {
    private final KeyData<Long> serverKeyData = new KeyData(this, DAO::serverKeyTable, 1000);
    private final KeyData<Long> userKeyData = new KeyData(this, DAO::userKeyTable, 3000);
    private final KeyData<Long> botKeyData = new KeyData(this, DAO::botKeyTable, 10);
    private final KeyData<Long> channelKeyData = new KeyData(this, DAO::channelKeyTable, 2000);
    private final KeyData<String> dictionaryKeyData = new KeyData(this, DAO::dictionaryKeyTable, 100);
    private final KeyData<String> dictionaryReplaceTypeKeyData = new KeyData(this, DAO::dictionaryReplaceTypeKeyTable, 100);
    private final KeyData<String> autoDisconnectModeKeyData = new KeyData(this, DAO::autoDisconnectModeKeyTable, 30);
    private final KeyData<String> voiceTypeKeyData = new KeyData(this, DAO::voiceTypeKeyTable, 100);
    private final LoadingCache<Long, ServerData> serverDataCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Long, ServerData>(){

        @NotNull
        public ServerData load(@NotNull Long key) {
            ServerDataImpl serverData = new ServerDataImpl(DataRepositoryImpl.this, key);
            serverData.init();
            return serverData;
        }
    });
    private final LoadingCache<ServerUserCacheKey, ServerUserData> serverUserDataCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<ServerUserCacheKey, ServerUserData>(){

        @NotNull
        public ServerUserData load(@NotNull ServerUserCacheKey key) {
            ServerUserDataImpl serverUserData = new ServerUserDataImpl(DataRepositoryImpl.this, key.serverId(), key.userId());
            serverUserData.init();
            return serverUserData;
        }
    });
    private final LoadingCache<ServerDictionaryCacheKey, DictionaryUseData> dictionaryUseDataCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<ServerDictionaryCacheKey, DictionaryUseData>(){

        @NotNull
        public DictionaryUseData load(@NotNull ServerDictionaryCacheKey key) {
            DictionaryUseDataImpl dictionaryUseData = new DictionaryUseDataImpl(DataRepositoryImpl.this, key.serverId(), key.dictionaryId());
            dictionaryUseData.init();
            return dictionaryUseData;
        }
    });
    private final LoadingCache<ServerBotCacheKey, BotStateData> botStateDataCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<ServerBotCacheKey, BotStateData>(){

        @NotNull
        public BotStateData load(@NotNull ServerBotCacheKey key) {
            BotStateDataImpl botStateData = new BotStateDataImpl(DataRepositoryImpl.this, key.serverId(), key.botId());
            botStateData.init();
            return botStateData;
        }
    });
    private final LoadingCache<Long, CustomDictionaryData> serverCustomDictionaryDataCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Long, CustomDictionaryData>(){

        @NotNull
        public CustomDictionaryData load(@NotNull Long key) {
            ServerCustomDictionaryData serverCustomDictionaryData = new ServerCustomDictionaryData(DataRepositoryImpl.this, key);
            serverCustomDictionaryData.init();
            return serverCustomDictionaryData;
        }
    });
    private final GlobalCustomDictionaryData globalCustomDictionaryData = new GlobalCustomDictionaryData(this);
    private final DAO dao;
    private final Set<RepoErrorListener> errorListeners = new HashSet<RepoErrorListener>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public DataRepositoryImpl(DAO dao) {
        this.dao = dao;
    }

    @Override
    public void init() {
        try {
            this.dao.init();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("DAO initialization failure", e);
        }
        try {
            this.initDataBase();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Database initialization failure", e);
        }
    }

    private void initDataBase() throws SQLException {
        try (Connection con = this.dao.getConnection();){
            this.dao.serverKeyTable().createTableIfNotExists(con);
            this.dao.userKeyTable().createTableIfNotExists(con);
            this.dao.botKeyTable().createTableIfNotExists(con);
            this.dao.channelKeyTable().createTableIfNotExists(con);
            this.dao.dictionaryKeyTable().createTableIfNotExists(con);
            this.dao.dictionaryReplaceTypeKeyTable().createTableIfNotExists(con);
            this.dao.autoDisconnectModeKeyTable().createTableIfNotExists(con);
            this.dao.voiceTypeKeyTable().createTableIfNotExists(con);
            this.dao.serverDataTable().createTableIfNotExists(con);
            this.dao.serverUserDataTable().createTableIfNotExists(con);
            this.dao.dictionaryUseDataTable().createTableIfNotExists(con);
            this.dao.botStateDataTable().createTableIfNotExists(con);
            this.dao.serverCustomDictionaryTable().createTableIfNotExists(con);
            this.dao.globalCustomDictionaryTable().createTableIfNotExists(con);
        }
    }

    @Override
    public void dispose() {
        if (this.destroyed.getAndSet(true)) {
            return;
        }
        if (this.dao != null) {
            try {
                this.dao.dispose();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to close DAO", e);
            }
        }
    }

    @Override
    public void addErrorListener(RepoErrorListener errorListener) {
        this.errorListeners.add(errorListener);
    }

    @Override
    public void removeErrorListener(RepoErrorListener errorListener) {
        this.errorListeners.remove(errorListener);
    }

    void fireErrorEvent(Throwable throwable) {
        if (this.destroyed.get()) {
            return;
        }
        for (RepoErrorListener errorListener : this.errorListeners) {
            errorListener.onError(throwable);
        }
    }

    DAO getDAO() {
        return this.dao;
    }

    KeyData<Long> getServerKeyData() {
        return this.serverKeyData;
    }

    KeyData<Long> getUserKeyData() {
        return this.userKeyData;
    }

    KeyData<Long> getBotKeyData() {
        return this.botKeyData;
    }

    KeyData<Long> getChannelKeyData() {
        return this.channelKeyData;
    }

    KeyData<String> getDictionaryKeyData() {
        return this.dictionaryKeyData;
    }

    KeyData<String> getDictionaryReplaceTypeKeyData() {
        return this.dictionaryReplaceTypeKeyData;
    }

    KeyData<String> getAutoDisconnectModeKeyData() {
        return this.autoDisconnectModeKeyData;
    }

    KeyData<String> getVoiceTypeKeyData() {
        return this.voiceTypeKeyData;
    }

    @Override
    @NotNull
    public ServerData getServerData(long serverId) {
        return (ServerData)this.serverDataCache.getUnchecked((Object)serverId);
    }

    @Override
    @NotNull
    public ServerUserData getServerUserData(long serverId, long userId) {
        return (ServerUserData)this.serverUserDataCache.getUnchecked((Object)new ServerUserCacheKey(serverId, userId));
    }

    @Override
    @NotNull
    public DictionaryUseData getDictionaryUseData(long serverId, String dictionaryId) {
        return (DictionaryUseData)this.dictionaryUseDataCache.getUnchecked((Object)new ServerDictionaryCacheKey(serverId, dictionaryId));
    }

    @Override
    @NotNull
    public BotStateData getBotStateData(long serverId, long botId) {
        return (BotStateData)this.botStateDataCache.getUnchecked((Object)new ServerBotCacheKey(serverId, botId));
    }

    @Override
    @NotNull
    public CustomDictionaryData getServerCustomDictionaryData(long serverId) {
        return (CustomDictionaryData)this.serverCustomDictionaryDataCache.getUnchecked((Object)serverId);
    }

    @Override
    @NotNull
    public CustomDictionaryData getGlobalCustomDictionaryData() {
        return this.globalCustomDictionaryData;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<Long, TTSChannelPair> getAllConnectedChannel(long botId) {
        Map<Long, TTSChannelPair> map;
        block9: {
            Connection connection = this.dao.getConnection();
            try {
                map = this.dao.botStateDataTable().selectAllConnectedChannelPairByBotKeyId(connection, this.botKeyData.getId(botId));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable3) {
                    this.fireErrorEvent(throwable3);
                    throw throwable3;
                }
            }
            connection.close();
        }
        return map;
    }

    @Override
    @NotNull
    public @Unmodifiable List<Long> getAllDenyUser(long serverId) {
        List<Long> list;
        block9: {
            Connection connection = this.dao.getConnection();
            try {
                list = this.dao.serverUserDataTable().selectAllDenyUser(connection, this.serverKeyData.getId(serverId));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable3) {
                    this.fireErrorEvent(throwable3);
                    throw throwable3;
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<DictionaryUseEntry> getAllDictionaryUseData(long serverId) {
        List<DictionaryUseEntry> list;
        block9: {
            Connection connection = this.dao.getConnection();
            try {
                list = this.dao.dictionaryUseDataTable().selectAll(connection, this.serverKeyData.getId(serverId));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable3) {
                    this.fireErrorEvent(throwable3);
                    throw throwable3;
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<Long, BotStateData> getAllBotStateData(long botId) {
        Map<Long, BotStateData> map;
        block9: {
            Connection connection = this.dao.getConnection();
            try {
                List<Long> allServerIdList = this.dao.botStateDataTable().selectAll(connection, this.botKeyData.getId(botId));
                map = allServerIdList.stream().map(it -> Pair.of((Object)it, (Object)this.getBotStateData((long)it, botId))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable3) {
                    this.fireErrorEvent(throwable3);
                    throw throwable3;
                }
            }
            connection.close();
        }
        return map;
    }

    private record ServerUserCacheKey(long serverId, long userId) {
    }

    private record ServerDictionaryCacheKey(long serverId, String dictionaryId) {
    }

    private record ServerBotCacheKey(long serverId, long botId) {
    }
}

