/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.DictionaryUseDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerDictionaryKey;
import dev.felnull.itts.core.savedata.repository.DictionaryUseData;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.RecordData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.OptionalInt;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.Nullable;

public class DictionaryUseDataImpl
extends RecordData<ServerDictionaryKey, DictionaryUseDataRecord>
implements DictionaryUseData {
    private final long serverId;
    private final String dictionaryId;

    DictionaryUseDataImpl(DataRepositoryImpl repository, long serverId, String dictionaryId) {
        super(repository);
        this.serverId = serverId;
        this.dictionaryId = dictionaryId;
    }

    @Override
    protected RecordData.InitRecordContext getInitRecordContext() {
        int serverKeyId = this.repository.getServerKeyData().getId(this.serverId);
        int dictionaryKeyId = this.repository.getDictionaryKeyData().getId(this.dictionaryId);
        ServerDictionaryKey serverDictionaryKey = new ServerDictionaryKey(serverKeyId, dictionaryKeyId);
        return new RecordData.InitRecordContext((RecordData)this, (DAO.DataTable)this.dao().dictionaryUseDataTable(), (Record)serverDictionaryKey, () -> new DictionaryUseDataRecord(null, null));
    }

    @Override
    @Nullable
    public Boolean isEnable() {
        return (Boolean)this.sqlProcReturnable(con -> this.dao().dictionaryUseDataTable().selectEnable((Connection)con, this.recordId()).orElse(null));
    }

    @Override
    public void setEnable(@Nullable Boolean enable) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().dictionaryUseDataTable().updateEnable((Connection)con, this.recordId(), enable)));
    }

    @Override
    @Nullable
    public Integer getPriority() {
        return (Integer)this.sqlProcReturnable(con -> {
            OptionalInt priority = this.dao().dictionaryUseDataTable().selectPriority((Connection)con, this.recordId());
            return priority.isPresent() ? Integer.valueOf(priority.getAsInt()) : null;
        });
    }

    @Override
    public void setPriority(@Nullable Integer priority) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().dictionaryUseDataTable().updatePriority((Connection)con, this.recordId(), priority)));
    }
}

