/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.dict.CustomDictionaryEntry;
import dev.felnull.itts.core.dict.ReplaceType;
import dev.felnull.itts.core.savedata.dao.DictionaryRecord;
import dev.felnull.itts.core.savedata.repository.CustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.IdCustomDictionaryEntryPair;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.SaveDataBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

class GlobalCustomDictionaryData
extends SaveDataBase
implements CustomDictionaryData {
    GlobalCustomDictionaryData(DataRepositoryImpl repository) {
        super(repository);
    }

    @Override
    @NotNull
    public @Unmodifiable List<IdCustomDictionaryEntryPair> getAll() {
        return (List)this.sqlProcReturnable(connection -> {
            Map<Integer, DictionaryRecord> dictData = this.dao().globalCustomDictionaryTable().selectRecords((Connection)connection);
            ImmutableList.Builder retBuilder = ImmutableList.builder();
            dictData.forEach((key, entry) -> {
                ReplaceType replaceType = ReplaceType.getByName(this.repository.getDictionaryReplaceTypeKeyData().getKey(entry.replaceTypeKeyId())).orElse(ReplaceType.CHARACTER);
                retBuilder.add((Object)new IdCustomDictionaryEntryPair((int)key, new CustomDictionaryEntry(entry.target(), entry.read(), replaceType)));
            });
            return retBuilder.build();
        });
    }

    @Override
    @NotNull
    public @Unmodifiable List<IdCustomDictionaryEntryPair> getByTarget(@NotNull String target) {
        return (List)this.sqlProcReturnable(connection -> {
            Map<Integer, DictionaryRecord> dictData = this.dao().globalCustomDictionaryTable().selectRecordByTarget((Connection)connection, target);
            ImmutableList.Builder retBuilder = ImmutableList.builder();
            dictData.forEach((key, entry) -> {
                ReplaceType replaceType = ReplaceType.getByName(this.repository.getDictionaryReplaceTypeKeyData().getKey(entry.replaceTypeKeyId())).orElse(ReplaceType.CHARACTER);
                retBuilder.add((Object)new IdCustomDictionaryEntryPair((int)key, new CustomDictionaryEntry(entry.target(), entry.read(), replaceType)));
            });
            return retBuilder.build();
        });
    }

    @Override
    public void add(@NotNull CustomDictionaryEntry dictionaryEntry) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            int replaceTypeKeyId = this.repository.getDictionaryReplaceTypeKeyData().getId(dictionaryEntry.replaceType().getName());
            DictionaryRecord record = new DictionaryRecord(dictionaryEntry.target(), dictionaryEntry.read(), replaceTypeKeyId);
            this.dao().globalCustomDictionaryTable().insertRecord((Connection)connection, record);
        }));
    }

    @Override
    public void remove(int entryId) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> this.dao().globalCustomDictionaryTable().deleteRecord((Connection)connection, entryId)));
    }
}

