/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.SaveDataBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeyData<T>
extends SaveDataBase {
    private final Function<DAO, DAO.KeyTable<T>> keyTableProvider;
    private final LoadingCache<T, Integer> idCache;
    private final LoadingCache<Integer, T> keyCache;

    KeyData(DataRepositoryImpl repository, Function<DAO, DAO.KeyTable<T>> keyTableProvider, int cacheSize) {
        super(repository);
        this.keyTableProvider = keyTableProvider;
        this.idCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(new CacheLoader<T, Integer>(){

            @NotNull
            public Integer load(@NotNull T key) {
                return (Integer)KeyData.this.sqlProcReturnable(connection -> KeyData.this.getIdFromDB((Connection)connection, key));
            }
        });
        this.keyCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(new CacheLoader<Integer, T>(){

            @NotNull
            public T load(@NotNull Integer id) {
                return KeyData.this.sqlProcReturnable(connection -> KeyData.this.getKeyFromDB((Connection)connection, id));
            }
        });
    }

    public int getId(@NotNull T key) {
        return (Integer)this.idCache.getUnchecked(key);
    }

    public OptionalInt getIdNullable(@Nullable T key) {
        if (key != null) {
            return OptionalInt.of(this.getId(key));
        }
        return OptionalInt.empty();
    }

    @Nullable
    public T getKey(int keyId) {
        if (keyId == 0) {
            return null;
        }
        return (T)this.keyCache.getUnchecked((Object)keyId);
    }

    private int getIdFromDB(Connection connection, T key) throws SQLException {
        DAO.KeyTable<T> keyTable = this.keyTableProvider.apply(this.dao());
        OptionalInt keyId = keyTable.selectId(connection, key);
        if (keyId.isPresent()) {
            return keyId.getAsInt();
        }
        keyTable.insertKeyIfNotExists(connection, key);
        return keyTable.selectId(connection, key).orElseThrow();
    }

    private T getKeyFromDB(Connection connection, int keyId) throws SQLException {
        DAO.KeyTable<T> keyTable = this.keyTableProvider.apply(this.dao());
        Optional<T> key = keyTable.selectKey(connection, keyId);
        return key.orElseThrow();
    }
}

