/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.SaveDataBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Supplier;

abstract class RecordData<K extends Record, T extends Record>
extends SaveDataBase {
    private int recordId = -1;

    RecordData(DataRepositoryImpl repository) {
        super(repository);
    }

    void init() {
        try (Connection con = this.dao().getConnection();){
            this.initRecord(con, this.getInitRecordContext());
        }
        catch (Throwable throwable) {
            IllegalStateException e = new IllegalStateException("Record initialization failure", throwable);
            this.repository.fireErrorEvent(e);
            throw e;
        }
    }

    private void initRecord(Connection connection, InitRecordContext context) throws SQLException {
        Object key;
        DAO.DataTable table = context.getTable();
        Optional record = table.selectRecordByKey(connection, key = context.getKey());
        if (record.isPresent()) {
            this.recordId = record.get().getId();
            return;
        }
        Record initialRecord = (Record)context.getInitialRecordProvider().get();
        table.insertRecordIfNotExists(connection, key, initialRecord);
        this.recordId = table.selectRecordByKey(connection, key).orElseThrow().getId();
    }

    protected abstract InitRecordContext getInitRecordContext();

    protected int recordId() {
        return this.recordId;
    }

    protected static class InitRecordContext {
        private final DAO.DataTable<K, T> table;
        private final K key;
        private final Supplier<T> initialRecordProvider;
        final /* synthetic */ RecordData this$0;

        protected InitRecordContext(DAO.DataTable<K, T> table, K key, Supplier<T> initialRecordProvider) {
            this.this$0 = this$0;
            this.table = table;
            this.key = key;
            this.initialRecordProvider = initialRecordProvider;
        }

        public DAO.DataTable<K, T> getTable() {
            return this.table;
        }

        public K getKey() {
            return this.key;
        }

        public Supplier<T> getInitialRecordProvider() {
            return this.initialRecordProvider;
        }
    }
}

