/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;

abstract class SaveDataBase {
    protected final DataRepositoryImpl repository;

    SaveDataBase(DataRepositoryImpl repository) {
        this.repository = repository;
    }

    protected DAO dao() {
        DAO dao = this.repository.getDAO();
        if (dao == null) {
            IllegalStateException e = new IllegalStateException("The DAO does not exist. The repository may not have been initialized or may have been destroyed.");
            this.repository.fireErrorEvent(e);
            throw e;
        }
        return dao;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T sqlProcReturnable(FailableFunction<Connection, T, SQLException> proc) {
        try (Connection con = this.dao().getConnection();){
            Object object = proc.apply((Object)con);
            return (T)object;
        }
        catch (Throwable throwable3) {
            IllegalStateException e = new IllegalStateException("SQL processing failed.", throwable3);
            this.repository.fireErrorEvent(e);
            throw e;
        }
    }

    protected void sqlProc(FailableConsumer<Connection, SQLException> proc) {
        try (Connection con = this.dao().getConnection();){
            proc.accept((Object)con);
        }
        catch (Throwable throwable) {
            IllegalStateException e = new IllegalStateException("SQL processing failed.", throwable);
            this.repository.fireErrorEvent(e);
            throw e;
        }
    }
}

