/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.dict.CustomDictionaryEntry;
import dev.felnull.itts.core.dict.ReplaceType;
import dev.felnull.itts.core.savedata.dao.DictionaryRecord;
import dev.felnull.itts.core.savedata.dao.ServerKey;
import dev.felnull.itts.core.savedata.repository.CustomDictionaryData;
import dev.felnull.itts.core.savedata.repository.IdCustomDictionaryEntryPair;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.SaveDataBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

class ServerCustomDictionaryData
extends SaveDataBase
implements CustomDictionaryData {
    private final long serverId;
    private ServerKey serverKey;

    ServerCustomDictionaryData(DataRepositoryImpl repository, long serverId) {
        super(repository);
        this.serverId = serverId;
    }

    void init() {
        this.serverKey = new ServerKey(this.repository.getServerKeyData().getId(this.serverId));
    }

    @Override
    @NotNull
    public @Unmodifiable List<IdCustomDictionaryEntryPair> getAll() {
        return (List)this.sqlProcReturnable(connection -> {
            Map<Integer, DictionaryRecord> dictData = this.dao().serverCustomDictionaryTable().selectRecords((Connection)connection, this.serverKey);
            ImmutableList.Builder retBuilder = ImmutableList.builder();
            dictData.forEach((key, entry) -> {
                ReplaceType replaceType = ReplaceType.getByName(this.repository.getDictionaryReplaceTypeKeyData().getKey(entry.replaceTypeKeyId())).orElse(ReplaceType.CHARACTER);
                retBuilder.add((Object)new IdCustomDictionaryEntryPair((int)key, new CustomDictionaryEntry(entry.target(), entry.read(), replaceType)));
            });
            return retBuilder.build();
        });
    }

    @Override
    @NotNull
    public @Unmodifiable List<IdCustomDictionaryEntryPair> getByTarget(@NotNull String target) {
        return (List)this.sqlProcReturnable(connection -> {
            Map<Integer, DictionaryRecord> dictData = this.dao().serverCustomDictionaryTable().selectRecordByTarget((Connection)connection, this.serverKey, target);
            ImmutableList.Builder retBuilder = ImmutableList.builder();
            dictData.forEach((key, entry) -> {
                ReplaceType replaceType = ReplaceType.getByName(this.repository.getDictionaryReplaceTypeKeyData().getKey(entry.replaceTypeKeyId())).orElse(ReplaceType.CHARACTER);
                retBuilder.add((Object)new IdCustomDictionaryEntryPair((int)key, new CustomDictionaryEntry(entry.target(), entry.read(), replaceType)));
            });
            return retBuilder.build();
        });
    }

    @Override
    public void add(@NotNull CustomDictionaryEntry dictionaryEntry) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> {
            int replaceTypeKeyId = this.repository.getDictionaryReplaceTypeKeyData().getId(dictionaryEntry.replaceType().getName());
            DictionaryRecord record = new DictionaryRecord(dictionaryEntry.target(), dictionaryEntry.read(), replaceTypeKeyId);
            this.dao().serverCustomDictionaryTable().insertRecord((Connection)connection, this.serverKey, record);
        }));
    }

    @Override
    public void remove(int entryId) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)connection -> this.dao().serverCustomDictionaryTable().deleteRecord((Connection)connection, entryId)));
    }
}

