/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.discord.AutoDisconnectMode;
import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.ServerDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerKey;
import dev.felnull.itts.core.savedata.repository.ServerData;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.RecordData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.OptionalInt;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.Nullable;

final class ServerDataImpl
extends RecordData<ServerKey, ServerDataRecord>
implements ServerData {
    private static final String INITIAL_DEFAULT_VOICE_TYPE = null;
    private static final String INITIAL_IGNORE_REGEX = "(!|/|\\\\$|`).*";
    private static final boolean INITIAL_NEED_JOIN = false;
    private static final boolean INITIAL_OVERWRITE_ALOUD = false;
    private static final boolean INITIAL_NOTIFY_MOVE = true;
    private static final int INITIAL_READ_LIMIT = 200;
    private static final int INITIAL_NAME_READ_LIMIT = 20;
    private static final AutoDisconnectMode INITIAL_AUTO_DISCONNECT_MODE = AutoDisconnectMode.OFF;
    private final long serverId;

    ServerDataImpl(DataRepositoryImpl repository, long serverId) {
        super(repository);
        this.serverId = serverId;
    }

    @Override
    protected RecordData.InitRecordContext getInitRecordContext() {
        int serverKyeId = this.repository.getServerKeyData().getId(this.serverId);
        ServerKey serverKey = new ServerKey(serverKyeId);
        return new RecordData.InitRecordContext((RecordData)this, (DAO.DataTable)this.dao().serverDataTable(), (Record)serverKey, () -> {
            OptionalInt defaultVoiceTypeKeyId = this.repository.getVoiceTypeKeyData().getIdNullable(INITIAL_DEFAULT_VOICE_TYPE);
            int autoDisconnectModeKeyId = this.repository.getAutoDisconnectModeKeyData().getId(INITIAL_AUTO_DISCONNECT_MODE.getName());
            return new ServerDataRecord(defaultVoiceTypeKeyId.isPresent() ? Integer.valueOf(defaultVoiceTypeKeyId.getAsInt()) : null, INITIAL_IGNORE_REGEX, false, false, true, 200, 20, autoDisconnectModeKeyId);
        });
    }

    @Override
    @Nullable
    public String getDefaultVoiceType() {
        return (String)this.sqlProcReturnable(con -> {
            OptionalInt voiceType = this.dao().serverDataTable().selectDefaultVoiceType((Connection)con, this.recordId());
            if (voiceType.isPresent()) {
                return this.repository.getVoiceTypeKeyData().getKey(voiceType.getAsInt());
            }
            return null;
        });
    }

    @Override
    public void setDefaultVoiceType(@Nullable String voiceType) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> {
            OptionalInt voiceTypeKeyId = this.repository.getVoiceTypeKeyData().getIdNullable(voiceType);
            this.dao().serverDataTable().updateDefaultVoiceType((Connection)con, this.recordId(), voiceTypeKeyId.isPresent() ? Integer.valueOf(voiceTypeKeyId.getAsInt()) : null);
        }));
    }

    @Override
    @Nullable
    public String getIgnoreRegex() {
        return (String)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectIgnoreRegex((Connection)con, this.recordId()).orElse(null));
    }

    @Override
    public void setIgnoreRegex(@Nullable String ignoreRegex) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateIgnoreRegex((Connection)con, this.recordId(), ignoreRegex)));
    }

    @Override
    public boolean isNeedJoin() {
        return (Boolean)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectNeedJoin((Connection)con, this.recordId()));
    }

    @Override
    public void setNeedJoin(boolean needJoin) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateNeedJoin((Connection)con, this.recordId(), needJoin)));
    }

    @Override
    public boolean isOverwriteAloud() {
        return (Boolean)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectOverwriteAloud((Connection)con, this.recordId()));
    }

    @Override
    public void setOverwriteAloud(boolean overwriteAloud) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateOverwriteAloud((Connection)con, this.recordId(), overwriteAloud)));
    }

    @Override
    public boolean isNotifyMove() {
        return (Boolean)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectNotifyMove((Connection)con, this.recordId()));
    }

    @Override
    public void setNotifyMove(boolean notifyMove) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateNotifyMove((Connection)con, this.recordId(), notifyMove)));
    }

    @Override
    public int getReadLimit() {
        return (Integer)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectReadLimit((Connection)con, this.recordId()));
    }

    @Override
    public void setReadLimit(int readLimit) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateReadLimit((Connection)con, this.recordId(), readLimit)));
    }

    @Override
    public int getNameReadLimit() {
        return (Integer)this.sqlProcReturnable(con -> this.dao().serverDataTable().selectNameReadLimit((Connection)con, this.recordId()));
    }

    @Override
    public void setNameReadLimit(int nameReadLimit) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverDataTable().updateNameReadLimit((Connection)con, this.recordId(), nameReadLimit)));
    }

    @Override
    public AutoDisconnectMode getAutoDisconnectMode() {
        return (AutoDisconnectMode)this.sqlProcReturnable(con -> {
            int autoDisMode = this.dao().serverDataTable().selectAutoDisconnectMode((Connection)con, this.recordId());
            return AutoDisconnectMode.getByName(this.repository.getAutoDisconnectModeKeyData().getKey(autoDisMode)).orElse(AutoDisconnectMode.OFF);
        });
    }

    @Override
    public void setAutoDisconnectMode(AutoDisconnectMode autoDisconnectMode) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> {
            int autoDisModeKeyId = this.repository.getAutoDisconnectModeKeyData().getId(autoDisconnectMode.getName());
            this.dao().serverDataTable().updateAutoDisconnectMode((Connection)con, this.recordId(), autoDisModeKeyId);
        }));
    }
}

