/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata.repository.impl;

import dev.felnull.itts.core.savedata.dao.DAO;
import dev.felnull.itts.core.savedata.dao.ServerUserDataRecord;
import dev.felnull.itts.core.savedata.dao.ServerUserKey;
import dev.felnull.itts.core.savedata.repository.ServerUserData;
import dev.felnull.itts.core.savedata.repository.impl.DataRepositoryImpl;
import dev.felnull.itts.core.savedata.repository.impl.RecordData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.OptionalInt;
import org.apache.commons.lang3.function.FailableConsumer;
import org.jetbrains.annotations.Nullable;

final class ServerUserDataImpl
extends RecordData<ServerUserKey, ServerUserDataRecord>
implements ServerUserData {
    private static final String INITIAL_VOICE_TYPE = null;
    private static final boolean INITIAL_DENY = false;
    private static final String INITIAL_NICK_NAME = null;
    private final long serverId;
    private final long userId;

    ServerUserDataImpl(DataRepositoryImpl repository, long serverId, long userId) {
        super(repository);
        this.serverId = serverId;
        this.userId = userId;
    }

    @Override
    protected RecordData.InitRecordContext getInitRecordContext() {
        int serverKeyId = this.repository.getServerKeyData().getId(this.serverId);
        int userKeyId = this.repository.getUserKeyData().getId(this.userId);
        ServerUserKey serverUserKey = new ServerUserKey(serverKeyId, userKeyId);
        return new RecordData.InitRecordContext((RecordData)this, (DAO.DataTable)this.dao().serverUserDataTable(), (Record)serverUserKey, () -> {
            OptionalInt voiceTypeKeyId = this.repository.getVoiceTypeKeyData().getIdNullable(INITIAL_VOICE_TYPE);
            return new ServerUserDataRecord(voiceTypeKeyId.isPresent() ? Integer.valueOf(voiceTypeKeyId.getAsInt()) : null, false, INITIAL_NICK_NAME);
        });
    }

    @Override
    @Nullable
    public String getVoiceType() {
        return (String)this.sqlProcReturnable(con -> {
            OptionalInt voiceType = this.dao().serverUserDataTable().selectVoiceType((Connection)con, this.recordId());
            if (voiceType.isPresent()) {
                return this.repository.getVoiceTypeKeyData().getKey(voiceType.getAsInt());
            }
            return null;
        });
    }

    @Override
    public void setVoiceType(@Nullable String voiceType) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> {
            OptionalInt voiceTypeKeyId = this.repository.getVoiceTypeKeyData().getIdNullable(voiceType);
            this.dao().serverUserDataTable().updateVoiceType((Connection)con, this.recordId(), voiceTypeKeyId.isPresent() ? Integer.valueOf(voiceTypeKeyId.getAsInt()) : null);
        }));
    }

    @Override
    public boolean isDeny() {
        return (Boolean)this.sqlProcReturnable(con -> this.dao().serverUserDataTable().selectDeny((Connection)con, this.recordId()));
    }

    @Override
    public void setDeny(boolean deny) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverUserDataTable().updateDeny((Connection)con, this.recordId(), deny)));
    }

    @Override
    @Nullable
    public String getNickName() {
        return (String)this.sqlProcReturnable(con -> this.dao().serverUserDataTable().selectNickName((Connection)con, this.recordId()).orElse(null));
    }

    @Override
    public void setNickName(@Nullable String nickName) {
        this.sqlProc((FailableConsumer<Connection, SQLException>)((FailableConsumer)con -> this.dao().serverUserDataTable().updateNickName((Connection)con, this.recordId(), nickName)));
    }
}

