/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.tts;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.repository.BotStateData;
import dev.felnull.itts.core.savedata.repository.DataRepository;
import dev.felnull.itts.core.tts.TTSInstance;
import dev.felnull.itts.core.tts.VCEventType;
import dev.felnull.itts.core.tts.saidtext.FileUploadSaidText;
import dev.felnull.itts.core.tts.saidtext.MessageSaidText;
import dev.felnull.itts.core.tts.saidtext.SaidText;
import dev.felnull.itts.core.tts.saidtext.VCEventSaidText;
import dev.felnull.itts.core.util.TTSUtils;
import dev.felnull.itts.core.voice.Voice;
import dev.felnull.itts.core.voice.VoiceType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TTSManager
implements ITTSRuntimeUse {
    private final Map<Long, TTSInstance> instances = new ConcurrentHashMap<Long, TTSInstance>();

    public int getTTSCount() {
        return this.instances.size();
    }

    public int getUserCount() {
        List guilds = this.getBot().getJDA().getGuilds();
        List<Long> ttsChannels = this.instances.values().stream().map(TTSInstance::getAudioChannel).toList();
        long users = guilds.stream().flatMap(guild -> guild.getVoiceStates().stream()).filter(voiceState -> voiceState.getChannel() != null).filter(voiceState -> {
            AudioChannelUnion channelUnion = voiceState.getChannel();
            if (channelUnion != null) {
                return ttsChannels.contains(channelUnion.getIdLong());
            }
            return false;
        }).filter(TTSUtils::canListen).count();
        return (int)users;
    }

    public void setReadAroundChannel(@NotNull Guild guild, @NotNull MessageChannel textChannel) {
        long guildId = guild.getIdLong();
        DataRepository dataRepository = SaveDataManager.getInstance().getRepository();
        BotStateData botStateData = dataRepository.getBotStateData(guildId, this.getBot().getBotId());
        botStateData.setReadAroundTextChannel(textChannel.getIdLong());
    }

    public void connect(@NotNull Guild guild, @NotNull AudioChannel audioChannel) {
        long guildId = guild.getIdLong();
        long channelId = audioChannel.getIdLong();
        TTSInstance pre = this.getTTSInstance(guildId);
        if (pre != null) {
            if (pre.getAudioChannel() == channelId) {
                return;
            }
            this.disconnect(guild);
        }
        DataRepository dataRepository = SaveDataManager.getInstance().getRepository();
        BotStateData botStateData = dataRepository.getBotStateData(guildId, this.getBot().getBotId());
        Long readTextChannel = botStateData.getReadAroundTextChannel();
        boolean overwriteAloud = dataRepository.getServerData(guildId).isOverwriteAloud();
        if (readTextChannel != null) {
            this.instances.put(guildId, new TTSInstance(guild, channelId, readTextChannel, overwriteAloud));
        }
        botStateData.setSpeakAudioChannel(channelId);
    }

    public void disconnect(@NotNull Guild guild) {
        long guildId = guild.getIdLong();
        TTSInstance instance = this.getTTSInstance(guildId);
        if (instance == null) {
            return;
        }
        instance.dispose();
        this.instances.remove(guildId);
        DataRepository dataRepository = SaveDataManager.getInstance().getRepository();
        BotStateData botStateData = dataRepository.getBotStateData(guildId, this.getBot().getBotId());
        botStateData.setSpeakAudioChannel(null);
    }

    public void reload(@NotNull Guild guild) {
        long guildId = guild.getIdLong();
        TTSInstance instance = this.getTTSInstance(guildId);
        if (instance == null) {
            return;
        }
        this.disconnect(guild);
        AudioChannel rc = (AudioChannel)guild.getChannelById(AudioChannel.class, instance.getAudioChannel());
        if (rc != null) {
            this.connect(guild, rc);
        }
    }

    @Nullable
    public TTSInstance getTTSInstance(long guildId) {
        return this.instances.get(guildId);
    }

    public void sayChat(@NotNull Guild guild, @NotNull MessageChannel messageChannel, @Nullable Member member, @NotNull Message message) {
        Pattern ignorePattern;
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        String ignoreRegex = legacySaveDataLayer.getServerData(guild.getIdLong()).getIgnoreRegex();
        if (ignoreRegex != null && (ignorePattern = Pattern.compile(ignoreRegex)).matcher(message.getContentDisplay()).matches()) {
            return;
        }
        this.sayGuildMemberText(guild, messageChannel, member, voice -> new MessageSaidText(message, (Voice)voice));
    }

    public void sayUploadFile(@NotNull Guild guild, @NotNull MessageChannel messageChannel, @Nullable Member member, @NotNull List<Message.Attachment> attachments) {
        if (attachments.isEmpty()) {
            return;
        }
        this.sayGuildMemberText(guild, messageChannel, member, voice -> new FileUploadSaidText((Voice)voice, attachments));
    }

    public void sayGuildMemberText(@NotNull Guild guild, @NotNull MessageChannel messageChannel, @Nullable Member member, @NotNull Function<Voice, SaidText> saidTextFactory) {
        VoiceType vt;
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        if (!this.canSpeak(guild)) {
            return;
        }
        long guildId = guild.getIdLong();
        long textChannelId = messageChannel.getIdLong();
        if (member == null) {
            return;
        }
        User user = member.getUser();
        if (user.isBot() || user.isSystem()) {
            return;
        }
        long userId = user.getIdLong();
        TTSInstance ti = this.getTTSInstance(guildId);
        if (ti == null || ti.getTextChannel() != textChannelId) {
            return;
        }
        if (legacySaveDataLayer.getServerData(guildId).isNeedJoin()) {
            GuildVoiceState vs = member.getVoiceState();
            if (vs == null) {
                return;
            }
            AudioChannelUnion vc = vs.getChannel();
            if (vc == null || vc.getIdLong() != ti.getAudioChannel()) {
                return;
            }
        }
        if ((vt = this.getVoiceManager().getVoiceType(guildId, userId)) == null) {
            return;
        }
        ti.sayText(saidTextFactory.apply(vt.createVoice(guildId, userId)));
    }

    public void sayText(@NotNull Guild guild, @NotNull SaidText saidText) {
        if (!this.canSpeak(guild)) {
            return;
        }
        long guildId = guild.getIdLong();
        TTSInstance ti = this.getTTSInstance(guildId);
        if (ti == null) {
            return;
        }
        ti.sayText(saidText);
    }

    public boolean canSpeak(@NotNull Guild guild) {
        long guildId = guild.getIdLong();
        TTSInstance ti = this.getTTSInstance(guildId);
        if (ti == null) {
            return false;
        }
        AudioChannel audioChannel = (AudioChannel)guild.getChannelById(AudioChannel.class, ti.getAudioChannel());
        if (audioChannel == null) {
            return false;
        }
        return guild.getVoiceStates().stream().filter(it -> it.getChannel() != null && it.getChannel().getIdLong() == audioChannel.getIdLong()).anyMatch(TTSUtils::canListen);
    }

    public void onVCEvent(@NotNull Guild guild, @NotNull Member member, @Nullable AudioChannelUnion join, @Nullable AudioChannelUnion left) {
        GuildVoiceState vcs;
        long guildId = guild.getIdLong();
        User user = member.getUser();
        long userId = user.getIdLong();
        TTSInstance ti = this.getTTSInstance(guildId);
        if (ti == null || (join == null || ti.getAudioChannel() != join.getIdLong()) && (left == null || ti.getAudioChannel() != left.getIdLong())) {
            return;
        }
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        if (!legacySaveDataLayer.getServerData(guildId).isNotifyMove()) {
            return;
        }
        VoiceType vt = this.getVoiceManager().getVoiceType(guildId, userId);
        if (vt == null) {
            return;
        }
        if (join != null && join.getIdLong() == ti.getAudioChannel() && (vcs = member.getVoiceState()) != null && vcs.isGuildMuted()) {
            return;
        }
        VCEventType vce = null;
        if (join != null && left == null) {
            vce = VCEventType.JOIN;
        } else if (join == null) {
            vce = VCEventType.LEAVE;
        } else if (join.getIdLong() == ti.getAudioChannel() && left.getIdLong() != ti.getAudioChannel()) {
            vce = VCEventType.MOVE_FROM;
        } else if (join.getIdLong() != ti.getAudioChannel() && left.getIdLong() == ti.getAudioChannel()) {
            vce = VCEventType.MOVE_TO;
        }
        if (this.canSpeak(guild)) {
            this.sayVCEvent(vce, ti, vt.createVoice(guildId, userId), member, join, left);
        }
    }

    private void sayVCEvent(VCEventType vcEventType, TTSInstance ttsInstance, Voice voice, Member member, AudioChannelUnion join, AudioChannelUnion left) {
        if (vcEventType == null) {
            return;
        }
        ttsInstance.sayText(new VCEventSaidText(voice, vcEventType, member, join, left));
    }
}

