/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.tts;

import dev.felnull.itts.core.util.TTSUtils;
import dev.felnull.itts.core.voice.Voice;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;

public enum VCEventType {
    JOIN((voice, member, join, left) -> VCEventType.getMemberName(voice, member) + "\u304c\u63a5\u7d9a\u3057\u307e\u3057\u305f", true),
    LEAVE((voice, member, join, left) -> VCEventType.getMemberName(voice, member) + "\u304c\u5207\u65ad\u3057\u307e\u3057\u305f", false),
    MOVE_FROM((voice, member, join, left) -> VCEventType.getMemberName(voice, member) + "\u304c" + VCEventType.getChannelName((StandardGuildChannel)left) + "\u304b\u3089\u79fb\u52d5\u3057\u3066\u304d\u307e\u3057\u305f", true),
    MOVE_TO((voice, member, join, left) -> VCEventType.getMemberName(voice, member) + "\u304c" + VCEventType.getChannelName((StandardGuildChannel)join) + "\u3078\u79fb\u52d5\u3057\u307e\u3057\u305f", false);

    private final VCEventMessage vcEventMessage;
    private final boolean join;

    private VCEventType(VCEventMessage saidMessage, boolean join) {
        this.vcEventMessage = saidMessage;
        this.join = join;
    }

    public boolean isJoin() {
        return this.join;
    }

    public String getMessage(Voice voice, Member member, AudioChannelUnion join, AudioChannelUnion left) {
        return this.vcEventMessage.getMessage(voice, member, join, left);
    }

    private static String getChannelName(StandardGuildChannel channel) {
        Objects.requireNonNull(channel);
        return TTSUtils.getTTSChannelName(channel);
    }

    private static String getMemberName(Voice voice, Member member) {
        return TTSUtils.getTTSName(voice, member);
    }

    private static interface VCEventMessage {
        public String getMessage(Voice var1, Member var2, AudioChannelUnion var3, AudioChannelUnion var4);
    }
}

