/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.tts.saidtext;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.tts.saidtext.SaidText;
import dev.felnull.itts.core.voice.Voice;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;

public record FileUploadSaidText(Voice voice, List<Message.Attachment> attachments) implements SaidText,
ITTSRuntimeUse
{
    @Override
    public CompletableFuture<String> getText() {
        return CompletableFuture.supplyAsync(() -> {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            Map<FileType, List<FileType>> fileTypes = this.attachments.stream().map(FileUploadSaidText::getFileType).collect(Collectors.groupingBy(it -> it));
            for (Map.Entry<FileType, List<FileType>> entry : fileTypes.entrySet()) {
                int ct = entry.getValue().size();
                if (ct >= 2) {
                    sb.append(entry.getValue().size()).append("\u500b\u306e");
                }
                sb.append(entry.getKey().getName());
                if (count < fileTypes.size() - 1) {
                    if (count == 0) {
                        sb.append("\u3068");
                    } else {
                        sb.append(",");
                    }
                }
                ++count;
            }
            sb.append("\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f");
            return sb.toString();
        }, this.getAsyncExecutor());
    }

    @Override
    public CompletableFuture<Voice> getVoice() {
        return CompletableFuture.completedFuture(this.voice);
    }

    private static FileType getFileType(Message.Attachment attachment) {
        if (attachment.isImage()) {
            return FileType.IMAGE;
        }
        if (attachment.isVideo()) {
            return FileType.VIDEO;
        }
        String ct = attachment.getContentType();
        if (ct != null && ct.startsWith("audio/")) {
            return FileType.AUDIO;
        }
        return FileType.FILE;
    }

    private static enum FileType {
        FILE("\u30d5\u30a1\u30a4\u30eb"),
        IMAGE("\u753b\u50cf"),
        VIDEO("\u52d5\u753b"),
        AUDIO("\u97f3\u58f0");

        private final String name;

        private FileType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

