/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.tts.saidtext;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.tts.saidtext.SaidText;
import dev.felnull.itts.core.util.TTSUtils;
import dev.felnull.itts.core.voice.Voice;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;

public record MessageSaidText(Message message, Voice voice) implements SaidText,
ITTSRuntimeUse
{
    private static final String REPLAY_MESSAGE = "%s\u306b\u8fd4\u4fe1\u3057\u307e\u3057\u305f\u3001%s";
    private static final String MY_MESSAGE = "\u81ea\u5206";
    private static final String UNKNOWN_MESSAGE = "\u4e0d\u660e\u306a\u30e1\u30c3\u30bb\u30fc\u30b8";
    private static final String PINNED_MESSAGE = "%s\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u30c1\u30e3\u30f3\u30cd\u30eb\u306b\u30d4\u30f3\u7559\u3081\u3057\u307e\u3057\u305f";
    private static final String UNKNOWN_PINNED_MESSAGE = "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u30c1\u30e3\u30f3\u30cd\u30eb\u306b\u30d4\u30f3\u7559\u3081\u3057\u307e\u3057\u305f";

    @Override
    public CompletableFuture<String> getText() {
        MessageType messageType = this.message.getType();
        if (messageType == MessageType.INLINE_REPLY) {
            return this.inlineReply();
        }
        if (messageType == MessageType.CHANNEL_PINNED_ADD) {
            return this.pined();
        }
        ConcurrentHashMap members = new ConcurrentHashMap();
        Stream<CompletableFuture> memberLoad = this.message.getMentions().getUsers().stream().map(user -> {
            Guild guild = this.message.getGuild();
            if (!guild.isMember((UserSnowflake)user)) {
                return CompletableFuture.runAsync(() -> members.put(user, (Member)guild.retrieveMember((UserSnowflake)user).complete()), this.getAsyncExecutor());
            }
            members.put(user, guild.getMember((UserSnowflake)user));
            return CompletableFuture.completedFuture(null);
        });
        return CompletableFuture.allOf((CompletableFuture[])memberLoad.toArray(CompletableFuture[]::new)).thenApplyAsync(v -> MessageSaidText.getIkisugiContentDisplay(members, this.message), this.getAsyncExecutor());
    }

    private static String getIkisugiContentDisplay(Map<User, Member> members, Message message) {
        String ret = message.getContentRaw();
        for (User user : message.getMentions().getUsers()) {
            String name = members.get(user).getEffectiveName();
            ret = ret.replaceAll("<@!?" + Pattern.quote(user.getId()) + ">", "@" + Matcher.quoteReplacement(name));
        }
        for (CustomEmoji emoji : message.getMentions().getCustomEmojis()) {
            ret = ret.replace(emoji.getAsMention(), ":" + emoji.getName() + ":");
        }
        for (GuildChannel mentionedChannel : message.getMentions().getChannels()) {
            ret = ret.replace(mentionedChannel.getAsMention(), "#" + mentionedChannel.getName());
        }
        for (Role mentionedRole : message.getMentions().getRoles()) {
            ret = ret.replace(mentionedRole.getAsMention(), "@" + mentionedRole.getName());
        }
        return ret;
    }

    private CompletableFuture<String> pined() {
        return CompletableFuture.supplyAsync(() -> {
            MessageReference reference = this.message.getMessageReference();
            String pinedTarget = null;
            if (reference != null) {
                Message pinMessage = reference.getMessage();
                if (pinMessage == null) {
                    try {
                        pinMessage = (Message)this.message.getChannel().retrieveMessageById(reference.getMessageIdLong()).complete();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (pinMessage != null) {
                    User pinAuthor = pinMessage.getAuthor();
                    pinedTarget = pinAuthor.getIdLong() == this.message.getAuthor().getIdLong() ? MY_MESSAGE : TTSUtils.getTTSName(this.voice, pinMessage.getGuild(), pinAuthor);
                }
            }
            return pinedTarget != null ? String.format(PINNED_MESSAGE, pinedTarget) : UNKNOWN_PINNED_MESSAGE;
        }, this.getAsyncExecutor());
    }

    private CompletableFuture<String> inlineReply() {
        return CompletableFuture.supplyAsync(() -> {
            User refUser;
            Message refMessage;
            MessageReference reference = this.message.getMessageReference();
            String replayTarget = reference != null && (refMessage = reference.getMessage()) != null ? ((refUser = refMessage.getAuthor()).getIdLong() == this.message.getAuthor().getIdLong() ? MY_MESSAGE : TTSUtils.getTTSName(this.voice, refMessage.getGuild(), refUser)) : UNKNOWN_MESSAGE;
            return String.format(REPLAY_MESSAGE, replayTarget, this.message.getContentDisplay());
        }, this.getAsyncExecutor());
    }

    @Override
    public CompletableFuture<Voice> getVoice() {
        return CompletableFuture.completedFuture(this.voice);
    }
}

