/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.util;

import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.ImmortalityTimer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ApoptosisObject {
    private final AtomicLong lastExtensionTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicReference<ImmortalityTimer.ImmortalityTimerTask> task = new AtomicReference();
    private final AtomicBoolean broken = new AtomicBoolean();
    private final long lifeTime;

    protected ApoptosisObject(long lifeTime) {
        this.lifeTime = lifeTime;
        this.scheduleCheckTimer(this::check, this.lifeTime + 300L);
    }

    protected abstract void lifeEnd(boolean var1);

    public void extensionLife() {
        this.lastExtensionTime.set(System.currentTimeMillis());
    }

    public void broke() {
        this.broken.set(true);
        ImmortalityTimer.ImmortalityTimerTask tsk = this.task.get();
        if (tsk != null) {
            tsk.cancel();
        }
        this.lifeEnd(true);
    }

    private void check() {
        if (this.broken.get()) {
            return;
        }
        this.task.set(null);
        long now = System.currentTimeMillis();
        long lastTime = this.lastExtensionTime.get();
        long eqTime = now - lastTime;
        if (eqTime >= this.lifeTime) {
            this.broken.set(true);
            this.lifeEnd(false);
            return;
        }
        this.scheduleCheckTimer(this::check, this.lifeTime - eqTime + 300L);
    }

    private void scheduleCheckTimer(final Runnable runnable, long delay) {
        ImmortalityTimer.ImmortalityTimerTask tsk = new ImmortalityTimer.ImmortalityTimerTask(){

            @Override
            public void run() {
                CompletableFuture.runAsync(runnable, ITTSRuntime.getInstance().getAsyncWorkerExecutor());
            }
        };
        this.task.set(tsk);
        ITTSRuntime.getInstance().getImmortalityTimer().schedule(tsk, delay);
    }
}

