/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.util;

import dev.felnull.itts.core.ITTSRuntime;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.requests.restaction.CacheRestAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiscordUtils {
    private DiscordUtils() {
    }

    @NotNull
    public static CompletableFuture<String> getNameAsync(@Nullable Guild guild, @NotNull User user) {
        Objects.requireNonNull(user);
        if (guild != null) {
            Member member = guild.getMember((UserSnowflake)user);
            if (member == null) {
                CacheRestAction memberCacheRestAction = guild.retrieveMember((UserSnowflake)user);
                return CompletableFuture.supplyAsync(() -> ((Member)memberCacheRestAction.complete()).getEffectiveName(), ITTSRuntime.getInstance().getAsyncWorkerExecutor());
            }
            return CompletableFuture.completedFuture(member.getEffectiveName());
        }
        return CompletableFuture.completedFuture(user.getName());
    }

    @NotNull
    public static String getName(@Nullable Guild guild, @NotNull User user) {
        Member member;
        Objects.requireNonNull(user);
        if (guild != null && (member = guild.getMember((UserSnowflake)user)) != null) {
            return member.getEffectiveName();
        }
        return user.getEffectiveName();
    }

    @NotNull
    public static String getEscapedName(@NotNull Member member) {
        return DiscordUtils.escapeMention(member.getEffectiveName());
    }

    @NotNull
    public static String getEscapedName(@Nullable Guild guild, @NotNull User user) {
        return DiscordUtils.escapeMention(DiscordUtils.getName(guild, user));
    }

    @NotNull
    public static String getEscapedName(@NotNull User user) {
        Objects.requireNonNull(user);
        return DiscordUtils.escapeMention(user.getName());
    }

    @NotNull
    public static String escapeMention(@NotNull String txt) {
        Objects.requireNonNull(txt);
        txt = Message.MentionType.EVERYONE.getPattern().matcher(txt).replaceAll(n -> "everyone");
        txt = Message.MentionType.HERE.getPattern().matcher(txt).replaceAll(n -> "here");
        txt = Message.MentionType.USER.getPattern().matcher(txt).replaceAll(n -> n.group().substring(2, n.group().length() - 1));
        txt = Message.MentionType.ROLE.getPattern().matcher(txt).replaceAll(n -> n.group().substring(2, n.group().length() - 1));
        return txt;
    }
}

