/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

public final class JsonUtils {
    private JsonUtils() {
    }

    @NotNull
    public static String getStringOrEmpty(@NotNull JsonObject jo, @NotNull String key) {
        JsonPrimitive jp = jo.getAsJsonPrimitive(key);
        if (jp == null) {
            return "";
        }
        if (!jp.isString()) {
            return "";
        }
        return jp.getAsString();
    }

    public static String getString(@NotNull JsonObject jo, @NotNull String key, String defaultValue) {
        if (!(jo.has(key) && jo.get(key).isJsonPrimitive() && jo.get(key).getAsJsonPrimitive().isString())) {
            return defaultValue;
        }
        return jo.get(key).getAsString();
    }

    public static int getInt(@NotNull JsonObject jo, @NotNull String key, int defaultValue) {
        if (!(jo.has(key) && jo.get(key).isJsonPrimitive() && jo.get(key).getAsJsonPrimitive().isNumber())) {
            return defaultValue;
        }
        return jo.get(key).getAsInt();
    }

    public static boolean getBoolean(@NotNull JsonObject jo, @NotNull String key, boolean defaultValue) {
        if (!(jo.has(key) && jo.get(key).isJsonPrimitive() && jo.get(key).getAsJsonPrimitive().isBoolean())) {
            return defaultValue;
        }
        return jo.get(key).getAsBoolean();
    }

    public static long getLong(@NotNull JsonObject jo, @NotNull String key, long defaultValue) {
        if (!(jo.has(key) && jo.get(key).isJsonPrimitive() && jo.get(key).getAsJsonPrimitive().isNumber())) {
            return defaultValue;
        }
        return jo.get(key).getAsLong();
    }
}

