/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.util;

import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public interface NameSerializableEnum {
    @NotNull
    public static <T extends Enum<T>> T getByName(@NotNull Class<T> enumClass, @NotNull String name, @NotNull T defaults) {
        return (T)((Enum)NameSerializableEnum.getByName(enumClass, name).orElse(defaults));
    }

    @NotNull
    public static <T extends Enum<T>> Optional<T> getByName(@NotNull Class<T> enumClass, @NotNull String name) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        return Arrays.stream(values).filter(it -> ((NameSerializableEnum)((Object)it)).getName().equals(name)).findFirst();
    }

    public String getName();
}

