/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice;

import dev.felnull.itts.core.ITTSBaseManager;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.savedata.legacy.LegacyServerUserData;
import dev.felnull.itts.core.voice.VoiceCategory;
import dev.felnull.itts.core.voice.VoiceType;
import dev.felnull.itts.core.voice.voicetext.VoiceTextManager;
import dev.felnull.itts.core.voice.voicevox.VoicevoxManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class VoiceManager
implements ITTSBaseManager {
    private final VoiceTextManager voiceTextManager = new VoiceTextManager();
    private final VoicevoxManager voicevoxManager = new VoicevoxManager("voicevox", () -> this.getConfigManager().getConfig().getVoicevoxConfig().getApiUrls(), () -> this.getConfigManager().getConfig().getVoicevoxConfig());
    private final VoicevoxManager coeiroinkManager = new VoicevoxManager("coeiroink", () -> this.getConfigManager().getConfig().getCoeirolnkConfig().getApiUrls(), () -> this.getConfigManager().getConfig().getCoeirolnkConfig());
    private final VoicevoxManager sharevoxManager = new VoicevoxManager("sharevox", () -> this.getConfigManager().getConfig().getSharevoxConfig().getApiUrls(), () -> this.getConfigManager().getConfig().getSharevoxConfig());
    private final List<Supplier<List<VoiceType>>> voiceTypes = new ArrayList<Supplier<List<VoiceType>>>();

    private void registerVoiceTypes(Supplier<List<VoiceType>> availableVoiceTypes) {
        this.voiceTypes.add(availableVoiceTypes);
    }

    @Override
    @NotNull
    public CompletableFuture<?> init() {
        return CompletableFuture.allOf(this.voicevoxManager.init(), this.coeiroinkManager.init(), this.sharevoxManager.init()).thenAcceptAsync(v -> {
            this.registerVoiceTypes(this.voiceTextManager::getVoiceTypes);
            this.registerVoiceTypes(this.voicevoxManager::getAvailableVoiceTypes);
            this.registerVoiceTypes(this.coeiroinkManager::getAvailableVoiceTypes);
            this.registerVoiceTypes(this.sharevoxManager::getAvailableVoiceTypes);
            this.getITTSLogger().info("Voice initial setup complete");
        }, this.getAsyncExecutor());
    }

    public VoiceTextManager getVoiceTextManager() {
        return this.voiceTextManager;
    }

    public VoicevoxManager getVoicevoxManager() {
        return this.voicevoxManager;
    }

    public VoicevoxManager getCoeiroinkManager() {
        return this.coeiroinkManager;
    }

    public VoicevoxManager getSharevoxManager() {
        return this.sharevoxManager;
    }

    @NotNull
    public @Unmodifiable Map<VoiceCategory, List<VoiceType>> getAvailableVoiceTypes() {
        return this.voiceTypes.stream().flatMap(n -> ((List)n.get()).stream()).filter(VoiceType::isAvailable).collect(Collectors.groupingBy(VoiceType::getCategory));
    }

    public Optional<VoiceCategory> getVoiceCategory(String id) {
        return this.getAvailableVoiceTypes().keySet().stream().filter(r -> r.getId().equals(id)).findAny();
    }

    public Optional<VoiceType> getVoiceType(String id) {
        return this.getAvailableVoiceTypes().values().stream().flatMap(Collection::stream).filter(v -> v.getId().equals(id)).findAny();
    }

    @Nullable
    public VoiceType getDefaultVoiceType() {
        return this.getAvailableVoiceTypes().values().stream().flatMap(Collection::stream).min(Comparator.comparingInt(vt -> this.voiceTextManager.getCategory() == vt.getCategory() ? 1 : 0)).orElse(null);
    }

    @Nullable
    public VoiceType getDefaultVoiceType(long guildId) {
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        String defaultVt = legacySaveDataLayer.getServerData(guildId).getDefaultVoiceType();
        if (defaultVt == null) {
            return this.getDefaultVoiceType();
        }
        return this.getVoiceType(defaultVt).orElseGet(this::getDefaultVoiceType);
    }

    @Nullable
    public VoiceType getVoiceType(long guildId, long userId) {
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        LegacyServerUserData serverUserData = legacySaveDataLayer.getServerUserData(guildId, userId);
        Optional<VoiceType> vt = this.getVoiceType(serverUserData.getVoiceType());
        return vt.orElseGet(() -> this.getDefaultVoiceType(guildId));
    }
}

