/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.screen.debug;

import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.BakedModelRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.IRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.ItemRenderTest;
import dev.felnull.otyacraftengine.client.model.OETestModels;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1160;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderTestScreen
extends OEBaseScreen {
    private static final List<IRenderTest> renderTests = new ArrayList<IRenderTest>();
    private int currentTest;
    private long eqAll;
    private long lastTime = -1L;
    private long rtAll;
    private int sampleCount;
    private int testCount = 1;
    private Motion motion = Motion.FIX;
    private class_1160 cameraPos = new class_1160(0.0f, 0.0f, 1.0f);
    private class_1160 cameraRot = new class_1160();
    private class_342 countBox;

    public RenderTestScreen(@Nullable class_437 parent) {
        super((class_2561)new class_2585("Render Test"), parent);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new class_4185(3, this.field_22790 - 23, 100, 20, class_5244.field_24339, n -> mc.method_1507(this.getParentScreen())));
        this.method_37063((class_364)new class_4185(106, this.field_22790 - 23, 100, 20, (class_2561)new class_2585("Reset"), n -> this.reset()));
        this.countBox = (class_342)this.method_37063((class_364)new class_342(RenderTestScreen.mc.field_1772, 209, this.field_22790 - 23, 70, 20, (class_2561)new class_2585("Count")));
        this.countBox.method_1852(String.valueOf(this.testCount));
        this.countBox.method_1863(n -> {
            block5: {
                if (!n.isEmpty()) {
                    try {
                        int val = Integer.parseInt(n);
                        if (val < 0) {
                            this.countBox.method_1852("0");
                            break block5;
                        }
                        this.setCount(val);
                    }
                    catch (NumberFormatException e) {
                        this.countBox.method_1852("0");
                    }
                } else {
                    this.countBox.method_1852("0");
                }
            }
        });
        this.method_37063((class_364)new class_4185(282, this.field_22790 - 23, 20, 20, (class_2561)new class_2585("-1"), n -> this.countBox.method_1852(String.valueOf(this.testCount - 1))));
        this.method_37063((class_364)new class_4185(305, this.field_22790 - 23, 20, 20, (class_2561)new class_2585("+1"), n -> this.countBox.method_1852(String.valueOf(this.testCount + 1))));
        this.method_37063((class_364)new class_4185(328, this.field_22790 - 23, 100, 20, (class_2561)new class_2585("Motion: " + this.motion.name()), n -> {
            this.motion = Motion.values()[(this.motion.ordinal() + 1) % Motion.values().length];
            n.method_25355((class_2561)new class_2585("Motion: " + this.motion.name()));
        }));
        if (!renderTests.isEmpty()) {
            this.method_37063((class_364)new class_4185(this.field_22789 - 23, 3, 20, 20, (class_2561)new class_2585("->"), n -> {
                this.currentTest = (this.currentTest + 1) % renderTests.size();
                this.reset();
            }));
            this.method_37063((class_364)new class_4185(this.field_22789 - 46, 3, 20, 20, (class_2561)new class_2585("<-"), n -> {
                this.currentTest = (this.currentTest - 1) % renderTests.size();
                if (this.currentTest < 0) {
                    this.currentTest = renderTests.size() - 1;
                }
                this.reset();
            }));
        }
        this.reset();
    }

    private void setCount(int count) {
        this.testCount = count;
    }

    public void method_25394(@NotNull class_4587 poseStack, int mx, int my, float f) {
        long rt = System.nanoTime() - this.lastTime;
        if (this.lastTime >= 0L) {
            this.rtAll += rt;
        }
        this.method_25434(0);
        float sy = (float)this.field_22790 - (float)this.field_22790 / 4.0f;
        this.drawRelativeFill(poseStack, 0.0f, 0.0f, this.field_22789, sy, -1);
        this.drawRelativeFill(poseStack, 0.0f, 0.0f, this.field_22789, sy - 1.0f, -16777216);
        super.method_25394(poseStack, mx, my, f);
        if (renderTests.isEmpty()) {
            return;
        }
        class_4597.class_4598 buf = mc.method_22940().method_23000();
        long st = System.nanoTime();
        this.renderTest(poseStack, (class_4597)buf, f, this.testCount);
        long eq = System.nanoTime() - st;
        buf.method_22993();
        this.eqAll += eq;
        ++this.sampleCount;
        float eqAvg = (float)this.eqAll / (float)this.sampleCount;
        float rtAvg = (float)this.rtAll / (float)(this.sampleCount - 1);
        this.drawTextBase(poseStack, RenderTestScreen.mc.field_1770, 3.0f, sy, 0xFFFFFF);
        String string = String.format("Rendering Time: %.3fms %06dns", Float.valueOf((float)eq / 1000000.0f), eq);
        Objects.requireNonNull(RenderTestScreen.mc.field_1772);
        this.drawTextBase(poseStack, string, 3.0f, sy + 9.0f + 1.0f, 0xFFFFFF);
        String string2 = String.format("Rendering Average Time: %.3fms %06dns", Float.valueOf(eqAvg / 1000000.0f), (int)eqAvg);
        Objects.requireNonNull(RenderTestScreen.mc.field_1772);
        this.drawTextBase(poseStack, string2, 3.0f, sy + (float)((9 + 1) * 2), 0xFFFFFF);
        String string3 = String.format("Return Time: %.3fms %06dns", Float.valueOf((float)rt / 1000000.0f), rt);
        float f2 = 3.0f + (float)this.field_22789 / 2.0f;
        Objects.requireNonNull(RenderTestScreen.mc.field_1772);
        this.drawTextBase(poseStack, string3, f2, sy + 9.0f + 1.0f, 0xFFFFFF);
        String string4 = String.format("Return Average Time: %.3fms %06dns", Float.valueOf(rtAvg / 1000000.0f), (int)rtAvg);
        float f3 = 3.0f + (float)this.field_22789 / 2.0f;
        Objects.requireNonNull(RenderTestScreen.mc.field_1772);
        this.drawTextBase(poseStack, string4, f3, sy + (float)((9 + 1) * 2), 0xFFFFFF);
        if (this.motion == Motion.MOTION) {
            class_1160 rv = SocketDebugService.getAngele(f);
            class_1160 pv = SocketDebugService.getPosition(f);
            String string5 = String.format("Debug Motion:  Yaw: %s  Pitch: %s  Roll: %s  x: %s  y: %s  z: %s", Float.valueOf(rv.method_4943()), Float.valueOf(rv.method_4945()), Float.valueOf(rv.method_4947()), Float.valueOf(pv.method_4943()), Float.valueOf(pv.method_4945()), Float.valueOf(pv.method_4947()));
            Objects.requireNonNull(RenderTestScreen.mc.field_1772);
            this.drawTextBase(poseStack, string5, 3.0f, sy + (float)((9 + 1) * 3), 0xFFFFFF);
        }
        this.lastTime = System.nanoTime();
    }

    public void method_25393() {
        super.method_25393();
        if (this.motion == Motion.FREE_LOOK) {
            float speed = 1.0f;
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1894)) {
                this.cameraPos.method_4948(0.0f, -speed, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1881)) {
                this.cameraPos.method_4948(0.0f, speed, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1849)) {
                this.cameraPos.method_4948(speed, 0.0f, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1913)) {
                this.cameraPos.method_4948(-speed, 0.0f, 0.0f);
            }
            if (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1867)) {
                this.cameraPos = new class_1160(0.0f, 0.0f, 1.0f);
                this.cameraRot = new class_1160();
            }
        }
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (this.motion == Motion.FREE_LOOK) {
            boolean l;
            boolean bl = l = i == 0;
            if (l) {
                this.cameraRot.method_4948(-((float)g), (float)f, 0.0f);
            } else {
                this.cameraPos.method_4948((float)f, (float)g, 0.0f);
            }
        }
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25401(double d, double e, double f) {
        if (this.motion == Motion.FREE_LOOK) {
            this.cameraPos.method_4948(0.0f, 0.0f, (float)f * (OEClientUtil.isKeyInput(RenderTestScreen.mc.field_1690.field_1832) ? 0.5f : 1.0f));
            this.cameraPos.method_4949(this.cameraPos.method_4943(), this.cameraPos.method_4945(), Math.max(this.cameraPos.method_4947(), 1.0f));
        }
        return super.method_25401(d, e, f);
    }

    private void reset() {
        this.eqAll = 0L;
        this.sampleCount = 0;
        this.lastTime = -1L;
        this.rtAll = 0L;
    }

    private void renderTest(@NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, float f, int count) {
        float sy = (float)this.field_22790 - (float)this.field_22790 / 4.0f;
        poseStack.method_22903();
        if (this.motion != Motion.TRANSLATED && this.motion != Motion.ROTED && this.motion != Motion.BOTH) {
            double x = (float)this.field_22789 / 2.0f;
            double y = sy / 2.0f;
            if (this.motion == Motion.FREE_LOOK) {
                poseStack.method_22904(x += (double)(this.cameraPos.method_4943() * this.cameraPos.method_4947()), y += (double)(this.cameraPos.method_4945() * this.cameraPos.method_4947()), 30.0);
                OERenderUtil.poseRotateAll(poseStack, this.cameraRot.method_4943(), this.cameraRot.method_4945(), this.cameraRot.method_4947());
                poseStack.method_22904(-x, -y, -30.0);
            }
            if (this.motion == Motion.MOTION) {
                class_1160 pv = SocketDebugService.getPosition(f);
                poseStack.method_22904(x += (double)pv.method_4943(), y += (double)pv.method_4947(), 30.0);
                class_1160 rv = SocketDebugService.getAngele(f);
                OERenderUtil.poseRotateY(poseStack, rv.method_4943());
                OERenderUtil.poseRotateZ(poseStack, rv.method_4947());
                poseStack.method_22904(-x, -y, -30.0);
            }
            poseStack.method_22904(x, y, 1050.0);
            poseStack.method_22905(1.0f, 1.0f, -1.0f);
            poseStack.method_22904(0.0, 0.0, 1000.0);
            poseStack.method_22905(30.0f, -30.0f, 30.0f);
            if (this.motion == Motion.FREE_LOOK) {
                OERenderUtil.poseScaleAll(poseStack, this.cameraPos.method_4947());
            }
        }
        for (int i = 0; i < count; ++i) {
            float sp = OERenderUtil.getParSecond(5000L) + 1.0f / (float)count * (float)i;
            if (sp > 1.0f) {
                sp -= 1.0f;
            }
            poseStack.method_22903();
            double x = (float)this.field_22789 / 2.0f;
            double y = sy / 2.0f;
            if (this.motion == Motion.TRANSLATED || this.motion == Motion.BOTH) {
                float par = (float)((double)sp * Math.toRadians(360.0));
                x += Math.sin(par) * (double)((float)this.field_22789 / 2.0f - 30.0f);
                y += Math.sin(2.0f * par) * (double)(sy / 2.0f - 30.0f);
            }
            if (this.motion == Motion.ROTED || this.motion == Motion.BOTH) {
                poseStack.method_22904(x, y, 30.0);
                OERenderUtil.poseRotateX(poseStack, sp * 360.0f);
                OERenderUtil.poseRotateY(poseStack, sp * 360.0f);
                OERenderUtil.poseRotateZ(poseStack, sp * 360.0f);
                poseStack.method_22904(-x, -y, -30.0);
            }
            if (this.motion == Motion.TRANSLATED || this.motion == Motion.ROTED || this.motion == Motion.BOTH) {
                poseStack.method_22904(x, y, 1050.0);
                poseStack.method_22905(1.0f, 1.0f, -1.0f);
                poseStack.method_22904(0.0, 0.0, 1000.0);
                poseStack.method_22905(30.0f, -30.0f, 30.0f);
            }
            this.renderTest(poseStack, multiBufferSource, f);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private void renderTest(@NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, float f) {
        IRenderTest rt = renderTests.get(this.currentTest);
        if (rt != null) {
            rt.renderTest(poseStack, multiBufferSource, f);
        }
    }

    public static void addRenderTest(IRenderTest renderTest) {
        renderTests.add(renderTest);
    }

    public static void fInit() {
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(new class_2960("otyacraftengine", "block/test_model")));
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(new class_2960("otyacraftengine", "item/test_item_kame")));
        RenderTestScreen.addRenderTest(new ItemRenderTest((class_1935)class_1802.field_8279));
        RenderTestScreen.addRenderTest(new ItemRenderTest((class_1935)class_1802.field_8773));
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(OETestModels.ORIGIN));
        RenderTestScreen.addRenderTest(new BakedModelRenderTest(OETestModels.XYZ_AXIS));
    }

    private static enum Motion {
        FIX,
        TRANSLATED,
        ROTED,
        BOTH,
        FREE_LOOK,
        MOTION;

    }
}

