/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.motion.Motion;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MotionLoader {
    public static final Logger LOGGER = LogManager.getLogger(MotionLoader.class);
    private static final Gson GSON = new Gson();
    private final Map<class_2960, Motion> motions = new HashMap<class_2960, Motion>();

    protected MotionLoader(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        profilerFiller.method_16065();
        for (class_2960 id : resourceManager.method_14488("oe_motion", path -> path.endsWith(".json"))) {
            profilerFiller.method_15396(id.toString());
            try (InputStream stream = resourceManager.method_14486(id).method_14482();
                 InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                JsonObject jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                String p = id.method_12832();
                this.motions.put(new class_2960(id.method_12836(), p.substring("oe_motion/".length(), p.length() - ".json".length())), Motion.of(jo));
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading motion resource json " + id, (Throwable)e);
            }
            profilerFiller.method_15407();
        }
        profilerFiller.method_16066();
    }

    public Map<class_2960, Motion> getMotions() {
        return ImmutableMap.copyOf(this.motions);
    }
}

