/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import org.jetbrains.annotations.Nullable;

public interface MotionSwapper {
    public static final MotionSwapper EMPTY = new MotionSwapper(){

        @Override
        @Nullable
        public MotionPoint swapPrePoint(Motion motion, float par, int num, MotionPoint pre, MotionPoint next) {
            return null;
        }

        @Override
        @Nullable
        public MotionPoint swapNextPoint(Motion motion, float par, int num, MotionPoint pre, MotionPoint next) {
            return null;
        }
    };

    public static MotionSwapper swapStartAndEnd(final MotionPoint start, final MotionPoint end) {
        return new MotionSwapper(){

            @Override
            @Nullable
            public MotionPoint swapPrePoint(Motion motion, float par, int num, MotionPoint pre, MotionPoint next) {
                if (num == 0) {
                    return start;
                }
                return null;
            }

            @Override
            @Nullable
            public MotionPoint swapNextPoint(Motion motion, float par, int num, MotionPoint pre, MotionPoint next) {
                if (num + 1 == motion.getPoints().size() - 1) {
                    return end;
                }
                return null;
            }
        };
    }

    @Nullable
    public MotionPoint swapPrePoint(Motion var1, float var2, int var3, MotionPoint var4, MotionPoint var5);

    @Nullable
    public MotionPoint swapNextPoint(Motion var1, float var2, int var3, MotionPoint var4, MotionPoint var5);
}

