/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.AnimatedGifEncoder;
import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2i;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNImageUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class OEImageUtil {
    public static boolean isImage(byte[] data) {
        return OEImageUtil.isGif(data) || FNImageUtil.isImage(data);
    }

    public static byte[] reductionSize(byte[] data, long size) throws IOException {
        int i;
        long lastSize = data.length;
        if (lastSize <= size) {
            return data;
        }
        GifDecoder decoder = new GifDecoder();
        if (decoder.read(new ByteArrayInputStream(data)) != 0) {
            return FNImageUtil.toByteArray(FNImageUtil.reductionSize(ImageIO.read(new ByteArrayInputStream(data)), size), "png");
        }
        float scale = (float)size / (float)lastSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.start(out);
        encoder.setRepeat(0);
        FNVec2i siz = null;
        for (i = 0; i < decoder.getFrameCount(); ++i) {
            BufferedImage fb = decoder.getFrame(i);
            byte[] le = FNImageUtil.toByteArray(fb, "png");
            BufferedImage img = FNImageUtil.reductionSize(fb, (long)((float)le.length * scale));
            if (siz == null) {
                siz = new FNVec2i(img.getWidth(), img.getHeight());
                continue;
            }
            if (siz.getX() <= img.getWidth() || siz.getY() <= img.getHeight()) continue;
            siz = new FNVec2i(img.getWidth(), img.getHeight());
        }
        if (siz != null) {
            for (i = 0; i < decoder.getFrameCount(); ++i) {
                encoder.setDelay(decoder.getDelay(i));
                encoder.addFrame(FNImageUtil.resize(decoder.getFrame(i), siz.getX(), siz.getY()));
            }
        }
        encoder.finish();
        return out.toByteArray();
    }

    public static boolean isGif(byte[] data) {
        GifDecoder decoder = new GifDecoder();
        return decoder.read(new ByteArrayInputStream(data)) == 0;
    }
}

