package dev.felnull.otyacraftengine.fabric.server.handler;

import dev.felnull.otyacraftengine.server.event.OEServerEventHooks;
import dev.felnull.otyacraftengine.server.level.LootTableAccess;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_60;

public class ServerHandler {
    public static void init() {
        LootTableLoadingCallback.EVENT.register(ServerHandler::onLootTableLoading);
    }

    public static void onLootTableLoading(class_3300 resourceManager, class_60 manager, class_2960 id, FabricLootSupplierBuilder supplier, LootTableLoadingCallback.LootTableSetter setter) {
        OEServerEventHooks.onLootTableLoading(id, manager, new LootTableAccess() {
            @Override
            public void set(class_52 table) {
                setter.set(table);
            }

            @Override
            public void addLootPool(class_2960 name, class_55.class_56 poolBuilder) {
                supplier.withPool(poolBuilder.method_355());
            }
        });
    }
}
