package dev.felnull.otyacraftengine.item;

import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import java.util.function.Function;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import var;

public class ItemContainer implements class_1263 {
    private final class_1799 itemStack;
    private final IPlayerItemLocation location;
    private final class_2371<class_1799> items;
    private final String tagName;
    private final Function<class_1657, Boolean> valid;

    public ItemContainer(class_1799 itemStack, IPlayerItemLocation location, int size, String tagName, Function<class_1657, Boolean> valid) {
        this.itemStack = itemStack;
        this.items = class_2371.method_10213(size, class_1799.field_8037);
        this.location = location;
        loadItemList(itemStack, items, tagName);
        this.tagName = tagName;
        this.valid = valid;
    }

    @Override
    public int method_5439() {
        return this.items.size();
    }

    @Override
    public boolean method_5442() {
        return items.stream().allMatch(class_1799::method_7960);
    }

    @Override
    public class_1799 method_5438(int i) {
        return items.get(i);
    }

    @Override
    public class_1799 method_5434(int i, int j) {
        var ret = class_1262.method_5430(items, i, j);
        saveItems();
        return ret;
    }

    @Override
    public class_1799 method_5441(int i) {
        var ret = class_1262.method_5428(items, i);
        saveItems();
        return ret;
    }

    @Override
    public void method_5447(int i, class_1799 stack) {
        class_1799 itemstack = items.get(i);
        boolean flag = !stack.method_7960() && stack.method_7962(itemstack) && class_1799.method_7975(stack, itemstack);
        items.set(i, stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (flag)
            this.method_5431();
    }

    public Function<class_1657, Boolean> getValid() {
        return valid;
    }

    public String getTagName() {
        return tagName;
    }

    @Override
    public void method_5431() {
        saveItems();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return !itemStack.method_7960() && valid.apply(player) && location.getItem(player) == itemStack;
    }

    @Override
    public void method_5448() {
        items.clear();
    }

    @Override
    public void method_5432(class_1657 player) {
        class_1263.super.method_5432(player);
        saveItems();
    }

    public class_2371<class_1799> getItems() {
        return items;
    }

    public IPlayerItemLocation getLocation() {
        return location;
    }

    public void saveItems() {
        saveItemList(itemStack, items, tagName);
    }

    public static void loadItemList(class_1799 itemStack, class_2371<class_1799> items, String tagName) {
        var tag = itemStack.method_7969();
        if (tag != null)
            class_1262.method_5429(tag.getCompound(tagName), items);
    }

    public static void saveItemList(class_1799 itemStack, class_2371<class_1799> items, String tagName) {
        var tag = itemStack.method_7948();
        if (!tag.contains(tagName))
            tag.put(tagName, new class_2487());
        class_1262.method_5426(tag.getCompound(tagName), items);
    }

    public class_1799 getItemStack() {
        return itemStack;
    }

    public static class_3908 createMenuProvider(class_1799 stack, IPlayerItemLocation location, int size, String tagName, MenuFactory factory) {
        var con = new ItemContainer(stack, location, size, tagName, player -> {
            if (location.getItem(player).method_7960() || stack.method_7960())
                return false;
            return location.getItem(player) == stack;
        });
        return new class_747((i, inventory, player1) -> factory.createMenu(i, inventory, con, class_2338.field_10980, stack, location), stack.method_7964());
    }

    public static interface MenuFactory {
        class_1703 createMenu(int i, class_1661 playerInventory, class_1263 container, class_2338 pos, class_1799 itemStack, IPlayerItemLocation location);
    }
}
