package dev.felnull.otyacraftengine.item.location;

import dev.felnull.otyacraftengine.OtyacraftEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import var;

public class PlayerItemLocations {
    private static final Map<class_2960, Function<class_2487, IPlayerItemLocation>> FACTORYS = new HashMap<>();
    public static final class_2960 HAND = new class_2960(OtyacraftEngine.MODID, "hand");

    public static void init() {
        register(HAND, HandItemLocation::factory);
    }

    private static void register(class_2960 location, Function<class_2487, IPlayerItemLocation> factory) {
        FACTORYS.put(location, factory);
    }

    public static IPlayerItemLocation create(class_2960 location, class_2487 tag) {
        var f = FACTORYS.get(location);
        if (f != null)
            return f.apply(tag);
        return null;
    }
}
