package dev.felnull.otyacraftengine.mixin.client;


import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.block.IIkisugiVoxelShape;
import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import var;

@Mixin(class_761.class)
public abstract class LevelRendererMixin {

    @Shadow
    private class_638 level;

    @Inject(method = "renderHitOutline", at = @At("HEAD"), cancellable = true)
    private void renderHitOutline(class_4587 poseStack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState, CallbackInfo ci) {
        var shapeType = OtyacraftEngine.CONFIG.highlightVoxelShape;
        if (shapeType != HighlightVoxelShapeType.OFF) {
            var shape = shapeType.getGetter();
            if (shape != null)
                class_761.method_22983(poseStack, vertexConsumer, shape.getShape(blockState, level, blockPos, class_3726.method_16195(entity)), (double) blockPos.method_10263() - d, (double) blockPos.method_10264() - e, (double) blockPos.method_10260() - f, 0.0F, 0.0F, 0.0F, 0.4F);
            ci.cancel();
        }
    }

    @Inject(method = "renderShape", at = @At("HEAD"), cancellable = true)
    private static void renderShape(class_4587 poseStack, class_4588 vertexConsumer, class_265 voxelShape, double x, double y, double z, float r, float g, float b, float a, CallbackInfo ci) {
        if (!OtyacraftEngine.CONFIG.ikisugiVoxelShape) return;
        if (((IIkisugiVoxelShape) voxelShape).getEdges() == null) return;
        ci.cancel();
        var pose = poseStack.method_23760();
        for (IIkisugiVoxelShape.Edge edge : ((IIkisugiVoxelShape) voxelShape).getEdges()) {
            renderShapeEdge(pose, vertexConsumer, edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ(), x, y, z, r, g, b, a);
        }
    }

    private static void renderShapeEdge(class_4587.class_4665 pose, class_4588 vertexConsumer, double sx, double sy, double sz, double ex, double ey, double ez, double x, double y, double z, float r, float g, float b, float a) {
        float q = (float) (ex - sx);
        float r2 = (float) (ey - sy);
        float s = (float) (ez - sz);
        float t = class_3532.method_15355(q * q + r2 * r2 + s * s);
        q /= t;
        r2 /= t;
        s /= t;
        vertexConsumer.method_22918(pose.method_23761(), (float) (sx + x), (float) (sy + y), (float) (sz + z)).method_22915(r, g, b, a).method_23763(pose.method_23762(), q, r2, s).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), (float) (ex + x), (float) (ey + y), (float) (ez + z)).method_22915(r, g, b, a).method_23763(pose.method_23762(), q, r2, s).method_1344();
    }
}
