package dev.felnull.otyacraftengine.networking;

import BlockEntityExistence;
import ItemExistence;
import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.handler.ClientMessageHandler;
import dev.felnull.otyacraftengine.server.handler.ServerMessageHandler;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class OEPackets {
    public static final class_2960 TEST = new class_2960(OtyacraftEngine.MODID, "test");
    public static final class_2960 BLOCK_ENTITY_SYNC = new class_2960(OtyacraftEngine.MODID, "block_entity_sync");
    public static final class_2960 BLOCK_ENTITY_INSTRUCTION = new class_2960(OtyacraftEngine.MODID, "block_entity_instruction");
    public static final class_2960 BLOCK_ENTITY_INSTRUCTION_RETURN = new class_2960(OtyacraftEngine.MODID, "block_entity_instruction_return");
    public static final class_2960 ITEM_INSTRUCTION = new class_2960(OtyacraftEngine.MODID, "item_instruction");
    public static final class_2960 ITEM_INSTRUCTION_RETURN = new class_2960(OtyacraftEngine.MODID, "item_instruction_return");

    public static void init() {
        NetworkManager.registerReceiver(NetworkManager.c2s(), BLOCK_ENTITY_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onBlockEntityInstructionMessage(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), ITEM_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onItemInstructionMessage(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        if (OtyacraftEngine.CONFIG.testMode)
            NetworkManager.registerReceiver(NetworkManager.s2c(), TEST, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onTestMessage(new TestMessage(friendlyByteBuf), packetContext));

        NetworkManager.registerReceiver(NetworkManager.s2c(), BLOCK_ENTITY_SYNC, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onBlockEntitySyncMessage(new BlockEntitySyncMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.s2c(), BLOCK_ENTITY_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onBlockEntityInstructionReturn(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.s2c(), ITEM_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onItemInstructionReturn(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static class ItemInstructionMessage implements PacketMessage {
        public final UUID instructionScreenID;
        public final ItemExistence itemExistence;
        public final String name;
        public final int num;
        public final class_2487 data;

        public ItemInstructionMessage(class_2540 bf) {
            this(bf.method_10790(), ItemExistence.readFBB(bf), bf.method_19772(), bf.readInt(), bf.method_10798());
        }

        public ItemInstructionMessage(UUID instructionScreenID, ItemExistence itemExistence, String name, int num, class_2487 data) {
            this.instructionScreenID = instructionScreenID;
            this.itemExistence = itemExistence;
            this.name = name;
            this.num = num;
            this.data = data;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(instructionScreenID);
            itemExistence.writeFBB(buf);
            buf.method_10814(name);
            buf.writeInt(num);
            buf.method_10794(data);
            return buf;
        }
    }

    public static class BlockEntityInstructionMessage implements PacketMessage {
        public final UUID instructionScreenID;
        public final BlockEntityExistence blockEntityExistence;
        public final String name;
        public final int num;
        public final class_2487 data;

        public BlockEntityInstructionMessage(class_2540 bf) {
            this(bf.method_10790(), BlockEntityExistence.readFBB(bf), bf.method_19772(), bf.readInt(), bf.method_10798());
        }

        public BlockEntityInstructionMessage(UUID instructionScreenID, BlockEntityExistence blockEntityExistence, String name, int num, class_2487 data) {
            this.instructionScreenID = instructionScreenID;
            this.blockEntityExistence = blockEntityExistence;
            this.name = name;
            this.num = num;
            this.data = data;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(instructionScreenID);
            blockEntityExistence.writeFBB(buf);
            buf.method_10814(name);
            buf.writeInt(num);
            buf.method_10794(data);
            return buf;
        }
    }

    public static class BlockEntitySyncMessage implements PacketMessage {
        public final BlockEntityExistence blockEntityExistence;
        public final class_2487 syncedData;

        public BlockEntitySyncMessage(class_2540 bf) {
            this(BlockEntityExistence.readFBB(bf), bf.method_10798());
        }

        public BlockEntitySyncMessage(BlockEntityExistence blockEntityExistence, class_2487 syncedData) {
            this.blockEntityExistence = blockEntityExistence;
            this.syncedData = syncedData;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            blockEntityExistence.writeFBB(buf);
            buf.method_10794(syncedData);
            return buf;
        }
    }

    public static class TestMessage implements PacketMessage {
        public final String str;
        public final int num;

        public TestMessage(class_2540 bf) {
            this(bf.method_19772(), bf.readInt());
        }

        public TestMessage(String str, int num) {
            this.str = str;
            this.num = num;
        }

        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814(str);
            buf.writeInt(num);
            return buf;
        }
    }
}
