package dev.felnull.otyacraftengine.vsg;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.class_238;
import net.minecraft.class_265;

public class TentativeVoxelShapeGenerator {
    public static JsonObject generate(class_265 shape, class_265 edge) {
        long st = System.currentTimeMillis();
        JsonObject jo = new JsonObject();
        jo.addProperty("time", System.currentTimeMillis());
        jo.addProperty("meta", "OtyacraftEngine Tentative VoxelShapeGenerator V1");
        jo.addProperty("version", 2);

        JsonArray shapes = new JsonArray();
        for (class_238 toAabb : shape.method_1090()) {
            JsonArray aabb = new JsonArray();
            aabb.add(toAabb.field_1323);
            aabb.add(toAabb.field_1322);
            aabb.add(toAabb.field_1321);
            aabb.add(toAabb.field_1320);
            aabb.add(toAabb.field_1325);
            aabb.add(toAabb.field_1324);
            shapes.add(aabb);
        }
        jo.add("shapes", shapes);

        JsonArray edges = new JsonArray();
        edge.method_1104((sx, sy, sz, ex, ey, ez) -> {
            JsonArray aabb = new JsonArray();
            aabb.add(sx);
            aabb.add(sy);
            aabb.add(sz);
            aabb.add(ex);
            aabb.add(ey);
            aabb.add(ez);
            edges.add(aabb);
        });

        jo.add("edges", edges);

        jo.addProperty("elapsed", System.currentTimeMillis() - st);
        return jo;
    }
}
