/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;

public class DynamicGifTexture
extends class_1043
implements class_1061 {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    public DynamicGifTexture(long duration, ImageFrame ... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    public void method_4622() {
        int ct = Math.toIntExact(this.getFrameByTime(System.currentTimeMillis() % this.duration));
        if (ct != this.last) {
            this.field_5200 = this.frames[ct].image();
            this.method_4524();
            this.last = ct;
        }
    }

    private int getFrameByTime(long time) {
        long dr = 0L;
        for (int i = 0; i < this.frames.length; ++i) {
            if (dr <= time && dr + this.frames[i].delay > time) {
                return i;
            }
            dr += this.frames[i].delay;
        }
        return 0;
    }

    public void close() {
        super.close();
        if (this.frames != null) {
            for (ImageFrame image : this.frames) {
                if (image == null) continue;
                image.image().close();
            }
        }
    }

    public record ImageFrame(class_1011 image, long delay) {
    }
}

