package dev.felnull.otyacraftengine.client.shape;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.io.Reader;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

/**
 * Client Ikisugi Voxel Shape Loader
 */
public class ClientIVShapeLoader {
    public static final Logger LOGGER = LogManager.getLogger(ClientIVShapeLoader.class);
    private static final Gson GSON = new Gson();
    private final Map<class_2960, VoxelClientShape> voxelClientShapes;

    protected ClientIVShapeLoader(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        profilerFiller.method_16065();

        ImmutableMap.Builder<class_2960, VoxelClientShape> builder = ImmutableMap.builder();

        resourceManager.method_14488("voxel_shape", loc -> loc.method_12832().endsWith(".json")).forEach(((location, resource) -> {
            profilerFiller.method_15396(location.toString());
            try (Reader reader = resource.method_43039()) {
                JsonObject jo = GSON.fromJson(reader, JsonObject.class);
                var p = location.method_12832();
                var vs = VoxelClientShape.parse(jo);
                if (vs != null)
                    builder.put(new class_2960(location.method_12836(), p.substring("voxel_shape/".length(), p.length() - ".json".length())), vs);
            } catch (Exception e) {
                LOGGER.error("Error occurred while loading shape resource json " + location, e);
            }
            profilerFiller.method_15407();
        }));

        profilerFiller.method_16066();

        voxelClientShapes = builder.build();
    }

    public Map<class_2960, VoxelClientShape> getVoxelClientShapes() {
        return voxelClientShapes;
    }
}
