package dev.felnull.otyacraftengine.fabric.client.model.impl;

import com.google.common.collect.ImmutableList;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Supplier;

public class OBJModel implements class_1087, FabricBakedModel {
    private final Mesh mesh;
    private final class_809 transforms;
    private final class_1058 atlasSprite;
    private final List<class_777> empty = ImmutableList.of();
    private List<class_777> bakedQuads;

    public OBJModel(Mesh mesh, class_809 transforms, class_1058 atlasSprite) {
        this.mesh = mesh;
        this.transforms = transforms;
        this.atlasSprite = atlasSprite;
    }

    @Override
    public boolean isVanillaAdapter() {
        return false;
    }

    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (mesh != null)
            context.meshConsumer().accept(mesh);
    }

    @Override
    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (mesh != null)
            context.meshConsumer().accept(mesh);
    }

    @Override
    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        if (direction != null) return empty;
        if (bakedQuads == null) {
            if (mesh != null)
                bakedQuads = ModelHelper.toQuadLists(mesh)[ModelHelper.NULL_FACE_ID];
            if (bakedQuads == null)
                bakedQuads = empty;
        }
        return bakedQuads;
    }

    @Override
    public boolean method_4708() {
        return true;
    }

    @Override
    public boolean method_4712() {
        return true;
    }

    @Override
    public boolean method_24304() {
        return false;
    }

    @Override
    public boolean method_4713() {
        return false;
    }

    @Override
    public class_1058 method_4711() {
        return this.atlasSprite;
    }

    @Override
    public class_809 method_4709() {
        return this.transforms;
    }

    @Override
    public class_806 method_4710() {
        return class_806.field_4292;
    }
}
