package dev.felnull.otyacraftengine.fabric.client.model.impl;

import Obj;
import com.mojang.datafixers.util.Pair;
import de.javagl.obj.*;
import dev.felnull.otyacraftengine.fabric.client.model.OBJOption;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_809;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Function;

public class OBJUnbakedModelModel implements class_1100 {
    public static final class_4730 DEFAULT_SPRITE = new class_4730(class_1723.field_21668, null);
    private final Obj modelObj;
    private final Map<String, OBJMtl> mtls;
    private final class_809 transforms;
    private final class_4730 material;
    private final OBJOption option;

    public OBJUnbakedModelModel(Obj modelObj, Map<String, OBJMtl> mtls, class_809 transforms, OBJOption option) {
        this.modelObj = ObjUtils.triangulate(modelObj);
        this.mtls = mtls;
        this.transforms = transforms;
        this.option = option;

        Mtl mtl = mtls.get("sprite");
        this.material = mtls.size() > 0 ? new class_4730(class_1723.field_21668, new class_2960((mtl == null ? mtls.values().iterator().next() : mtl).getMapKd())) : DEFAULT_SPRITE;
    }

    @Override
    public Collection<class_2960> method_4755() {
        return Collections.emptySet();
    }

    @Override
    public Collection<class_4730> method_4754(Function<class_2960, class_1100> function, Set<Pair<String, String>> set) {
        List<class_4730> sprites = new ArrayList<>();
        mtls.values().forEach(mtl -> sprites.add(new class_4730(class_1723.field_21668, new class_2960(mtl.getMapKd()))));
        return sprites;
    }

    @Nullable
    @Override
    public class_1087 method_4753(class_1088 modelBakery, Function<class_4730, class_1058> function, class_3665 modelState, class_2960 resourceLocation) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer == null)
            renderer = IndigoRenderer.INSTANCE;

        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(modelObj);
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();

        for (Map.Entry<String, Obj> entry : materialGroups.entrySet()) {
            String matName = entry.getKey();
            Obj matGroupObj = entry.getValue();
            OBJMtl mtl = mtls.get(matName);
            int color = -1;
            class_1058 mtlSprite = function.apply(DEFAULT_SPRITE);
            if (mtl != null) {
                FloatTuple diffuseColor = mtl.getKd();
                if (mtl.isUseDiffuseColor()) {
                    color = 0xFF000000;
                    for (int i = 0; i < 3; ++i) {
                        color |= (int) (255 * diffuseColor.get(i)) << (16 - 8 * i);
                    }
                }
                mtlSprite = function.apply(new class_4730(class_1723.field_21668, new class_2960(mtl.getMapKd())));
            }
            for (int i = 0; i < matGroupObj.getNumFaces(); i++) {
                FloatTuple floatTuple;
                class_1160 vertex;
                FloatTuple normal;
                int v;
                for (v = 0; v < matGroupObj.getFace(i).getNumVertices(); v++) {
                    floatTuple = matGroupObj.getVertex(matGroupObj.getFace(i).getVertexIndex(v));
                    vertex = new class_1160(floatTuple.getX(), floatTuple.getY(), floatTuple.getZ());
                    normal = matGroupObj.getNormal(matGroupObj.getFace(i).getNormalIndex(v));
                    addVertex(i, v, vertex, normal, emitter, matGroupObj, false, modelState);
                    if (v == 2 && matGroupObj.getFace(i).getNumVertices() == 3) {
                        addVertex(i, 3, vertex, normal, emitter, matGroupObj, true, modelState);
                    }
                }
                emitter.spriteColor(0, color, color, color, color);
                emitter.material(renderer.materialFinder().find());
                if (mtl != null)
                    emitter.colorIndex(mtl.getTintIndex());
                emitter.nominalFace(emitter.lightFace());
                emitter.spriteBake(0, mtlSprite, MutableQuadView.BAKE_NORMALIZED | (modelState.method_3512() ? MutableQuadView.BAKE_LOCK_UV : 0));

                emitter.emit();
            }
        }
        var mesh = builder.build();
        return new OBJModel(mesh, transforms, function.apply(material));
    }

    private void addVertex(int faceIndex, int vertIndex, class_1160 vertex, FloatTuple normal, QuadEmitter emitter, Obj matGroup, boolean degenerate, class_3665 modelState) {
        try {
            int textureCoordIndex = vertIndex;
            if (degenerate)
                textureCoordIndex--;

            if (modelState.method_3509() != class_4590.method_22931() && !degenerate) {
                vertex.method_4948(-0.5F, -0.5F, -0.5F);
                vertex.method_19262(modelState.method_3509().method_22937());
                vertex.method_4948(0.5f, 0.5f, 0.5f);
            }

            emitter.pos(vertIndex, vertex.method_4943(), vertex.method_4945(), vertex.method_4947());
            emitter.normal(vertIndex, normal.getX(), normal.getY(), normal.getZ());

            if (modelObj.getNumTexCoords() > 0) {
                FloatTuple text = matGroup.getTexCoord(matGroup.getFace(faceIndex).getTexCoordIndex(textureCoordIndex));
                float v = text.getY();
                if (option.isFlipV())
                    v = 1f - v;
                emitter.sprite(vertIndex, 0, text.getX(), v);
            } else {
                emitter.nominalFace(class_2350.method_10142(normal.getX(), normal.getY(), normal.getZ()));
            }
        } catch (Exception ignored) {
        }
    }
}
