package dev.felnull.otyacraftengine.tag;

import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_6862;

@ApiStatus.Internal
public class ManualTagHolderImpl<T> implements ManualTagHolder<T> {
    private static final List<ManualTagHolderImpl<?>> GENERATED = new ArrayList<>();
    private final class_6862<T> tagKey;
    private final Consumer<TagProviderWrapper.TagAppenderWrapper<T>> tagRegister;

    public ManualTagHolderImpl(class_6862<T> tagKey, Consumer<TagProviderWrapper.TagAppenderWrapper<T>> tagRegister) {
        this.tagKey = tagKey;
        this.tagRegister = tagRegister;
    }

    public ManualTagHolderImpl(class_6862<T> tagKey) {
        this(tagKey, null);
    }

    @Override
    public @NotNull class_6862<T> getKey() {
        return tagKey;
    }

    @Override
    public void registering(@NotNull TagProviderWrapper.TagProviderAccess<T> tagProviderAccess) {
        if (GENERATED.contains(this)) return;
        GENERATED.add(this);

        if (tagRegister != null)
            tagRegister.accept(tagProviderAccess.tag(getKey()));
    }
}
