package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.gui.TextureSpecify;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseWidget;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class IconButton extends OEBaseWidget {
    @NotNull
    private final Consumer<IconButton> onPress;
    @NotNull
    protected TextureSpecify iconTexture;

    public IconButton(int x, int y, int width, int height, @NotNull class_2561 message, @NotNull TextureSpecify iconTexture, @NotNull Consumer<IconButton> onPress) {
        super(x, y, width, height, "button", message);
        this.onPress = onPress;
        this.iconTexture = iconTexture;
    }

    @Override
    public void onPress() {
        onPress.accept(this);
    }

    public @NotNull
    TextureSpecify getIconTexture() {
        return iconTexture;
    }

    public void setIconTexture(@NotNull TextureSpecify iconTexture) {
        this.iconTexture = iconTexture;
    }

    @Override
    public void method_25359(@NotNull class_4587 poseStack, int i, int j, float f) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, field_22757);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        int k = this.method_25356(this.method_25367());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.method_25302(poseStack, this.field_22760, this.field_22761, 0, 46 + k * 20, this.field_22758 / 2, this.field_22759);
        this.method_25302(poseStack, this.field_22760 + this.field_22758 / 2, this.field_22761, 200 - this.field_22758 / 2, 46 + k * 20, this.field_22758 / 2, this.field_22759);
        this.method_25353(poseStack, minecraft, i, j);
        renderIcon(poseStack, i, j, f);
    }

    protected void renderIcon(@NotNull class_4587 poseStack, int i, int j, float f) {
        iconTexture.draw(poseStack, field_22760 + (field_22758 - iconTexture.getWidth()) / 2f, field_22761 + (field_22759 - iconTexture.getHeight()) / 2f);
    }
}
